/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.container;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.FilterIterator;
import org.infinispan.commons.util.FilterSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.container.impl.PeekableTouchableCaffeineMap;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.reactivestreams.Publisher;
import org.wildfly.clustering.cache.caffeine.CacheConfiguration;
import org.wildfly.clustering.cache.caffeine.CacheFactory;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;

public class EvictableDataContainer<K, V>
extends AbstractInternalDataContainer<K, V> {
    private final Executor executor;
    private final PeekableTouchableMap<K, V> entries;
    private final Cache<K, InternalCacheEntry<K, V>> evictionCache;

    EvictableDataContainer(BasicComponentRegistry registry, Configuration configuration) {
        ConcurrentHashMap futures = new ConcurrentHashMap();
        BiConsumer<Object, InternalCacheEntry> evictionListener = (key, entry) -> {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            futures.put(key, future);
            this.handleEviction((InternalCacheEntry<K, V>)entry, future);
        };
        BiConsumer<Object, InternalCacheEntry> removalListener = (key, entry) -> {
            CompletableFuture future = (CompletableFuture)futures.remove(key);
            if (future != null) {
                future.complete(null);
            }
        };
        org.wildfly.clustering.function.Supplier factory = DataContainerConfigurationBuilder::new;
        DataContainerConfiguration container = Optional.ofNullable((DataContainerConfiguration)configuration.module(DataContainerConfiguration.class)).orElseGet((Supplier<DataContainerConfiguration>)factory.thenApply(Builder::create));
        CacheConfiguration.Builder builder = CacheConfiguration.builder();
        if (configuration.memory().maxCount() > 0L) {
            builder.withMaxWeight(configuration.memory().maxCount()).evictableWhen(container.evictable());
        }
        Optional.ofNullable(container.idleTimeout()).ifPresent(arg_0 -> ((CacheConfiguration.Builder)builder).evictAfter(arg_0));
        Optional.ofNullable(registry.getComponent("org.infinispan.executors.expiration", ScheduledExecutorService.class)).map(ComponentRef::running).ifPresent(arg_0 -> ((CacheConfiguration.Builder)builder).withExecutor(arg_0));
        this.executor = (Executor)registry.getComponent("org.infinispan.executors.non-blocking", Executor.class).running();
        this.evictionCache = new CacheFactory().apply(builder.whenEvicted(evictionListener).whenRemoved(removalListener).build());
        this.entries = new PeekableTouchableCaffeineMap(this.evictionCache);
    }

    void handleEviction(InternalCacheEntry<K, V> entry, CompletableFuture<Void> future) {
        EvictableDataContainer.handleEviction(entry, (DataOperationOrderer)this.orderer, (PassivationManager)((PassivationManager)this.passivator.running()), (EvictionManager)this.evictionManager, (DataContainer)this, (Executor)this.executor, future);
    }

    protected PeekableTouchableMap<K, V> getMapForSegment(int segment) {
        return this.entries;
    }

    protected int getSegmentForKey(Object key) {
        return -1;
    }

    public int sizeIncludingExpired() {
        return this.entries.size();
    }

    public void clear(IntSet segments) {
        Iterator<InternalCacheEntry<K, V>> iter = this.iteratorIncludingExpired(segments);
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Stop
    public void clear() {
        this.entries.clear();
    }

    public Publisher<InternalCacheEntry<K, V>> publisher(IntSet segments) {
        return Flowable.fromIterable(() -> this.iterator(segments));
    }

    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new AbstractInternalDataContainer.EntryIterator((AbstractInternalDataContainer)this, this.entries.values().iterator());
    }

    public Iterator<InternalCacheEntry<K, V>> iterator(IntSet segments) {
        return new FilterIterator(this.iterator(), entry -> segments.contains(this.keyPartitioner.getSegment(entry.getKey())));
    }

    public Spliterator<InternalCacheEntry<K, V>> spliterator() {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired());
    }

    public Spliterator<InternalCacheEntry<K, V>> spliterator(IntSet segments) {
        return new FilterSpliterator(this.spliterator(), entry -> segments.contains(this.keyPartitioner.getSegment(entry.getKey())));
    }

    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return this.entries.values().spliterator();
    }

    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        return new FilterSpliterator(this.spliteratorIncludingExpired(), entry -> segments.contains(this.keyPartitioner.getSegment(entry.getKey())));
    }

    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        return this.entries.values().iterator();
    }

    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        return new FilterIterator(this.iteratorIncludingExpired(), entry -> segments.contains(this.keyPartitioner.getSegment(entry.getKey())));
    }

    public void forEachSegment(ObjIntConsumer<PeekableTouchableMap<K, V>> segmentMapConsumer) {
        segmentMapConsumer.accept(this.entries, 0);
    }

    public void addSegments(IntSet segments) {
        throw new UnsupportedOperationException();
    }

    public void removeSegments(IntSet segments) {
        throw new UnsupportedOperationException();
    }

    public long evictionSize() {
        return ((Policy.Eviction)this.evictionCache.policy().eviction().orElseThrow()).weightedSize().orElse(this.entries.size());
    }

    public long capacity() {
        return ((Policy.Eviction)this.evictionCache.policy().eviction().orElseThrow()).getMaximum();
    }

    public void resize(long newSize) {
        ((Policy.Eviction)this.evictionCache.policy().eviction().orElseThrow()).setMaximum(newSize);
    }

    public void cleanUp() {
        this.evictionCache.cleanUp();
    }
}

