/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.container;

import java.time.Duration;
import java.util.function.Predicate;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfiguration;

public class DataContainerConfigurationBuilder
implements Builder<DataContainerConfiguration> {
    private final AttributeSet attributes = new AttributeSet(DataContainerConfiguration.class, new AttributeDefinition[]{DataContainerConfiguration.EVICTABLE, DataContainerConfiguration.IDLE_TIMEOUT});

    public DataContainerConfigurationBuilder(ConfigurationBuilder builder) {
        this();
    }

    DataContainerConfigurationBuilder() {
    }

    public <K> DataContainerConfigurationBuilder evictable(Predicate<K> evictable) {
        this.attributes.attribute(DataContainerConfiguration.EVICTABLE).set(evictable);
        return this;
    }

    public DataContainerConfigurationBuilder idleTimeout(Duration timeout) {
        this.attributes.attribute(DataContainerConfiguration.IDLE_TIMEOUT).set((Object)timeout);
        return this;
    }

    public void validate() {
    }

    public DataContainerConfiguration create() {
        return new DataContainerConfiguration(this.attributes);
    }

    public DataContainerConfigurationBuilder read(DataContainerConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

