/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.container;

import java.time.Duration;
import java.util.function.Predicate;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;

@BuiltBy(value=DataContainerConfigurationBuilder.class)
public class DataContainerConfiguration
implements Matchable<DataContainerConfiguration> {
    static final AttributeDefinition<Predicate> EVICTABLE = AttributeDefinition.builder((String)"evictable", (Object)org.wildfly.clustering.function.Predicate.always(), Predicate.class).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).immutable().build();
    static final AttributeDefinition<Duration> IDLE_TIMEOUT = AttributeDefinition.builder((String)"idle-timeout", null, Duration.class).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).immutable().build();
    private final AttributeSet attributes;

    DataContainerConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public <K> Predicate<K> evictable() {
        return (Predicate)this.attributes.attribute(EVICTABLE).get();
    }

    public Duration idleTimeout() {
        return (Duration)this.attributes.attribute(IDLE_TIMEOUT).get();
    }

    public boolean matches(DataContainerConfiguration configuration) {
        return this.attributes.matches(configuration.attributes);
    }
}

