/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.common;

import io.dekorate.testing.openshift.OpenshiftExtension;
import io.dekorate.testing.openshift.config.OpenshiftIntegrationTestConfig;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.wildfly.test.cloud.common.WildFlyCommonExtension;
import org.wildfly.test.cloud.common.WildFlyOpenshiftIntegrationTest;
import org.wildfly.test.cloud.common.WildFlyOpenshiftIntegrationTestConfig;

public class WildFlyOpenshiftExtension
extends OpenshiftExtension {
    private static final String TEST_CONFIG = "integration-test-config";
    private final WildFlyCommonExtension delegate = WildFlyCommonExtension.createForOpenshift();

    public WildFlyOpenshiftIntegrationTestConfig getIntegrationTestConfig(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(WildFlyCommonExtension.WILDFLY_STORE);
        WildFlyOpenshiftIntegrationTestConfig cfg = (WildFlyOpenshiftIntegrationTestConfig)store.get((Object)TEST_CONFIG, WildFlyOpenshiftIntegrationTestConfig.class);
        if (cfg != null) {
            return cfg;
        }
        cfg = context.getElement().map(e -> WildFlyOpenshiftIntegrationTestConfig.adapt(e.getAnnotation(WildFlyOpenshiftIntegrationTest.class))).orElseThrow(() -> new IllegalStateException("Test class not annotated with @" + WildFlyOpenshiftIntegrationTestConfig.class.getSimpleName()));
        store.put((Object)TEST_CONFIG, (Object)cfg);
        return cfg;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.delegate.beforeAll(this.getIntegrationTestConfig(context), context);
        super.beforeAll(context);
    }

    public void afterAll(ExtensionContext context) {
        this.delegate.dumpPodInformation(context);
        super.afterAll(context);
        this.delegate.afterAll(this.getIntegrationTestConfig(context), context);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        super.postProcessTestInstance(testInstance, context);
        this.delegate.postProcessTestInstance(testInstance, context, () -> this.getName(context));
    }

    public OpenshiftIntegrationTestConfig getOpenshiftIntegrationTestConfig(ExtensionContext context) {
        return this.getIntegrationTestConfig(context);
    }
}

