/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.common;

import io.dekorate.DekorateException;
import io.dekorate.testing.Testing;
import io.dekorate.testing.WithDiagnostics;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.utils.Serialization;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.fabric8.kubernetes.client.readiness.Readiness;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.wildfly.test.cloud.common.ConfigPlaceholderReplacer;
import org.wildfly.test.cloud.common.ExtraTestSetup;
import org.wildfly.test.cloud.common.KubernetesResource;
import org.wildfly.test.cloud.common.Resource;
import org.wildfly.test.cloud.common.TestHelper;
import org.wildfly.test.cloud.common.ValueInjector;
import org.wildfly.test.cloud.common.WildFlyIntegrationTestConfig;
import org.wildfly.test.cloud.common.WildFlyKubernetesIntegrationTest;
import org.wildfly.test.cloud.common.WildFlyKubernetesIntegrationTestConfig;

abstract class WildFlyCommonExtension
implements WithDiagnostics,
WithKubernetesClient {
    private static final String DUMP_LOGS_PROPERTY = "wildfly.test.print.logs";
    private static final String DUMP_SERVER_CONFIG_PROPERTY = "wildfly.test.print.server-config";
    private static final Logger LOGGER = Logger.getLogger(WildFlyCommonExtension.class);
    private final ExtensionType extensionType;
    private final Queue<AutoCloseable> closeables;
    static final ExtensionContext.Namespace WILDFLY_STORE = ExtensionContext.Namespace.create((Object[])new Object[]{"org", "wildfly", "test"});
    private static final String KUBERNETES_CONFIG_DATA = "kubernetes-config";

    public WildFlyCommonExtension() {
        this(null);
    }

    private WildFlyCommonExtension(ExtensionType extensionType) {
        this.extensionType = extensionType;
        this.closeables = new LinkedList<AutoCloseable>();
    }

    static WildFlyCommonExtension createForKubernetes() {
        return new Kubernetes();
    }

    static WildFlyCommonExtension createForOpenshift() {
        return new Openshift();
    }

    public WildFlyIntegrationTestConfig getIntegrationTestConfig(ExtensionContext context) {
        return context.getElement().map(e -> WildFlyKubernetesIntegrationTestConfig.adapt(e.getAnnotation(WildFlyKubernetesIntegrationTest.class))).orElseThrow(() -> new IllegalStateException("Test class not annotated with @" + WildFlyKubernetesIntegrationTest.class.getSimpleName()));
    }

    public void beforeAll(WildFlyIntegrationTestConfig config, ExtensionContext context) throws Exception {
        WildFlyTestContext testContext = this.initTestContext(context, config);
        if (config != null) {
            this.setNamespace(context, config, testContext);
            ExtraTestSetup extraTestSetup = config.getExtraTestSetup();
            config.addAdditionalKubernetesResources(extraTestSetup.beforeAll(context));
            this.deployKubernetesResources(context, config, testContext);
        }
        this.backupAndReplacePlaceholdersInKubernetesYaml(context, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(WildFlyIntegrationTestConfig config, ExtensionContext context) {
        WildFlyTestContext testContext = this.getTestContext(context);
        boolean error = false;
        if (testContext != null) {
            try {
                this.cleanupKubernetesResources(context, config, testContext);
            }
            catch (Throwable t) {
                t.printStackTrace();
                error = true;
            }
            finally {
                AutoCloseable c;
                this.deleteNamespace(context, config, testContext);
                while ((c = this.closeables.poll()) != null) {
                    try {
                        c.close();
                    }
                    catch (Exception e) {
                        LOGGER.debugf((Throwable)e, "Failed to close %s", (Object)c);
                    }
                }
            }
            if (error) {
                Assertions.fail((String)"Errors occurred cleaning up the test, see the logs for details");
            }
        }
        if (Files.exists(this.extensionType.backup, new LinkOption[0])) {
            try {
                Files.delete(this.extensionType.backup);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void dumpPodInformation(ExtensionContext context) {
        this.dumpLogs(context);
        this.dumpStandaloneXml(context);
    }

    private void dumpLogs(ExtensionContext context) {
        if (!this.dumpInformation(context, DUMP_LOGS_PROPERTY)) {
            return;
        }
        TestHelper helper = this.getTestHelperForDumping(context, "display logs");
        if (helper == null) {
            return;
        }
        System.out.println();
        System.out.println("==============================================================");
        System.out.println("  Outputting full pod logs...");
        System.out.println("==============================================================\n\n\n");
        Map<String, String> logs = helper.getAllPodLogs();
        for (String podName : logs.keySet()) {
            System.out.println("==============> LOGS FOR POD: " + podName + " <==================\n");
            System.out.println(logs.get(podName));
            System.out.println("==============> END LOGS: " + podName + " <=======================\n\n\n\n\n\n");
        }
    }

    private void dumpStandaloneXml(ExtensionContext context) {
        if (!this.dumpInformation(context, DUMP_SERVER_CONFIG_PROPERTY)) {
            return;
        }
        TestHelper helper = this.getTestHelperForDumping(context, "display logs");
        if (helper == null) {
            return;
        }
        System.out.println();
        System.out.println("==============================================================");
        System.out.println("  standalone.xml contents");
        System.out.println("==============================================================\n\n\n");
        String standaloneXml = helper.readFile("$JBOSS_HOME/standalone/configuration/standalone.xml");
        System.out.println(standaloneXml);
        System.out.println("==============> END standalone.xml <==========================\n\n\n\n\n\n");
    }

    private boolean dumpInformation(ExtensionContext context, String property) {
        if (!System.getProperties().containsKey(property)) {
            return false;
        }
        String value = System.getProperty(property);
        if (!value.equals("true")) {
            Object[] classes = value.split(",");
            System.out.println(Arrays.toString(classes));
            HashSet<Object> classesSet = new HashSet<Object>(Arrays.asList(classes));
            String testClass = ((Class)context.getTestClass().get()).getSimpleName();
            if (!classesSet.contains(testClass)) {
                return false;
            }
        }
        return true;
    }

    private TestHelper getTestHelperForDumping(ExtensionContext context, String useCase) {
        WildFlyTestContext testContext = this.getTestContext(context);
        if (testContext == null) {
            System.out.printf("Null WildFlyTestContext. Can't %s at this point...\n", useCase);
            return null;
        }
        TestHelper helper = testContext.getHelper();
        if (helper == null) {
            System.out.printf("Null TestHelper. Can't %s at this point...\n", useCase);
            return null;
        }
        return helper;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context, Supplier<String> nameSupplier) {
        String projectName = nameSupplier.get();
        final TestHelper helper = new TestHelper(this.getKubernetesClient(context), projectName);
        WildFlyTestContext testContext = this.getTestContext(context);
        testContext.setHelper(helper);
        LinkedHashMap injectors = new LinkedHashMap(this.createValueInjectors(this.getIntegrationTestConfig(context).valueInjectors()));
        ServiceLoader<ValueInjector> loader = ServiceLoader.load(ValueInjector.class);
        loader.forEach(injector -> {
            ValueInjector found = injectors.putIfAbsent(injector.supportedType(), (ValueInjector)injector);
            if (found != null) {
                LOGGER.debugf("Type %s already has an injector %s defined. Ignoring injector %s.", injector.supportedType(), (Object)found, injector);
            }
        });
        ValueInjector testHelperInjector = new ValueInjector(){

            @Override
            public Class<?> supportedType() {
                return TestHelper.class;
            }

            @Override
            public Object resolve(ExtensionContext context) {
                return helper;
            }
        };
        injectors.put(testHelperInjector.supportedType(), testHelperInjector);
        for (Class<?> clazz = testInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Arrays.stream(clazz.getDeclaredFields()).forEach(field -> {
                if (Arrays.stream(field.getDeclaredAnnotations()).noneMatch(a -> a.annotationType().getSimpleName().equalsIgnoreCase("Inject"))) {
                    return;
                }
                for (ValueInjector injector : injectors.values()) {
                    if (!injector.canInject(field.getType())) continue;
                    field.setAccessible(true);
                    Object value = injector.resolve(context);
                    if (value instanceof AutoCloseable) {
                        this.closeables.add((AutoCloseable)value);
                    }
                    try {
                        field.set(testInstance, value);
                        break;
                    }
                    catch (IllegalAccessException e) {
                        if (value instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)value).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw DekorateException.launderThrowable((Throwable)e);
                    }
                }
            });
        }
    }

    private Map<Class<?>, ValueInjector> createValueInjectors(Class<? extends ValueInjector>[] valueInjectors) {
        LinkedHashMap result = new LinkedHashMap();
        for (Class<? extends ValueInjector> type : valueInjectors) {
            try {
                Constructor<? extends ValueInjector> constructor = type.getConstructor(new Class[0]);
                ValueInjector instance = constructor.newInstance(new Object[0]);
                ValueInjector found = result.putIfAbsent(instance.supportedType(), instance);
                if (found == null) continue;
                LOGGER.warnf("Type %s already has an injector %s defined. Ignoring injector %s.", instance.supportedType(), (Object)found, (Object)instance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(String.format("Failed to find a default constructor for type %s", type), e);
            }
        }
        return result;
    }

    private WildFlyTestContext initTestContext(ExtensionContext context, WildFlyIntegrationTestConfig config) {
        if (config != null) {
            WildFlyTestContext testContext = new WildFlyTestContext();
            ExtensionContext.Store store = context.getStore(WILDFLY_STORE);
            store.put((Object)KUBERNETES_CONFIG_DATA, (Object)testContext);
            return testContext;
        }
        return null;
    }

    private WildFlyTestContext getTestContext(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(WILDFLY_STORE);
        return (WildFlyTestContext)store.get((Object)KUBERNETES_CONFIG_DATA, WildFlyTestContext.class);
    }

    protected abstract void setNamespace(ExtensionContext var1, WildFlyIntegrationTestConfig var2, WildFlyTestContext var3) throws Exception;

    protected abstract void deleteNamespace(ExtensionContext var1, WildFlyIntegrationTestConfig var2, WildFlyTestContext var3);

    private void deployKubernetesResources(ExtensionContext context, WildFlyIntegrationTestConfig config, WildFlyTestContext testContext) {
        if (config.getKubernetesResources().isEmpty()) {
            return;
        }
        for (KubernetesResource kubernetesResource : config.getKubernetesResources()) {
            KubernetesList resourceList;
            try (InputStream in = this.getLocalOrRemoteKubernetesResourceInputStream(kubernetesResource.definitionLocation());){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuilder replacedInput = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    line = this.performConfigPlaceholderReplacementForLine(context, config, line);
                    replacedInput.append(line);
                    replacedInput.append("\n");
                    line = reader.readLine();
                }
                resourceList = Serialization.unmarshalAsList((InputStream)new ByteArrayInputStream(replacedInput.toString().getBytes(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                throw WildFlyCommonExtension.toRuntimeException(e);
            }
            this.startResourcesInList(context, kubernetesResource, resourceList);
        }
    }

    private String performConfigPlaceholderReplacementForLine(ExtensionContext context, WildFlyIntegrationTestConfig config, String line) {
        for (Map.Entry<String, ConfigPlaceholderReplacer> replacement : config.getPlaceholderReplacements().entrySet()) {
            String placeholder = replacement.getKey();
            ConfigPlaceholderReplacer replacer = replacement.getValue();
            if (!line.contains(placeholder)) continue;
            line = replacer.replace(context, placeholder, line);
        }
        return line;
    }

    private void startResourcesInList(ExtensionContext context, KubernetesResource kubernetesResource, KubernetesList resourceList) {
        KubernetesClient client = this.getKubernetesClient(context);
        resourceList.getItems().stream().forEach(i -> {
            client.resourceList(new HasMetadata[]{i}).createOrReplace();
            System.out.println("Created: " + i.getKind() + " name:" + i.getMetadata().getName() + ".");
        });
        List waitables = resourceList.getItems().stream().filter(i -> i instanceof Deployment || i instanceof Pod || i instanceof ReplicaSet || i instanceof ReplicationController).collect(Collectors.toList());
        long started = System.currentTimeMillis();
        System.out.println("Waiting until ready (" + kubernetesResource.readinessTimeout() + " ms)...");
        try {
            this.waitUntilCondition(context, waitables, i -> Readiness.getInstance().isReady(i), kubernetesResource.readinessTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Gave up waiting after " + kubernetesResource.readinessTimeout());
        }
        long ended = System.currentTimeMillis();
        System.out.println("Waited: " + (ended - started) + " ms.");
        waitables.stream().map(r -> (HasMetadata)client.resource(r).fromServer().get()).forEach(i -> {
            if (!Readiness.getInstance().isReady(i)) {
                this.readinessFailed(context);
                System.out.println(i.getKind() + ":" + i.getMetadata().getName() + " not ready!");
            }
        });
        if (this.hasReadinessFailed(context)) {
            throw new IllegalStateException("Readiness Failed");
        }
        if (kubernetesResource.additionalResourcesCreated().length > 0) {
            long end = started + kubernetesResource.readinessTimeout();
            HashMap<String, ResourceGetter> resourceGetters = new HashMap<String, ResourceGetter>();
            for (Resource resource : kubernetesResource.additionalResourcesCreated()) {
                if (resourceGetters.put(resource.name(), ResourceGetter.create(client, resource)) == null) continue;
                throw new IllegalStateException(resource.name() + " appears more than once in additionalResourcesCreated()");
            }
            HashMap additionalWaitables = new HashMap();
            while (System.currentTimeMillis() < end) {
                for (Map.Entry entry : resourceGetters.entrySet()) {
                    ResourceGetter getter;
                    Object hasMetadata;
                    if (additionalWaitables.containsKey(entry.getKey()) || (hasMetadata = (getter = (ResourceGetter)entry.getValue()).getResource()) == null) continue;
                    additionalWaitables.put((String)entry.getKey(), hasMetadata);
                }
                if (additionalWaitables.size() == resourceGetters.size()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw new IllegalStateException(e);
                }
            }
            if (additionalWaitables.size() != resourceGetters.size()) {
                throw new IllegalStateException("Could not start all items in " + kubernetesResource.readinessTimeout());
            }
            try {
                this.waitUntilCondition(context, additionalWaitables.values(), i -> Readiness.getInstance().isReady(i), end - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Gave up waiting after " + (System.currentTimeMillis() - started));
            }
            waitables.stream().map(r -> (HasMetadata)client.resource(r).fromServer().get()).forEach(i -> {
                if (!Readiness.getInstance().isReady(i)) {
                    this.readinessFailed(context);
                    System.out.println(i.getKind() + ":" + i.getMetadata().getName() + " not ready!");
                }
            });
            if (this.hasReadinessFailed(context)) {
                throw new IllegalStateException("Readiness Failed");
            }
        }
    }

    private InputStream getLocalOrRemoteKubernetesResourceInputStream(String definitionLocation) throws IOException {
        try {
            URL url = new URL(definitionLocation);
            return new BufferedInputStream(url.openStream());
        }
        catch (MalformedURLException e) {
            Path path = Path.of(definitionLocation, new String[0]);
            if (!path.isAbsolute()) {
                path = Path.of(".", new String[0]).resolve(path).normalize();
            }
            if (!Files.exists(path, new LinkOption[0])) {
                Assertions.fail((String)(definitionLocation + " resolves to the follwing non-existant location: " + path));
            }
            return new BufferedInputStream(new FileInputStream(path.toFile()));
        }
    }

    private void cleanupKubernetesResources(ExtensionContext context, WildFlyIntegrationTestConfig config, WildFlyTestContext testContext) {
        if (config.getKubernetesResources().isEmpty()) {
            return;
        }
        List<KubernetesResource> kubernetesResources = config.getKubernetesResources();
        for (int i = kubernetesResources.size() - 1; i >= 0; --i) {
            KubernetesResource kubernetesResource = kubernetesResources.get(i);
            KubernetesList resourceList = null;
            try (InputStream in = this.getLocalOrRemoteKubernetesResourceInputStream(kubernetesResource.definitionLocation());){
                resourceList = Serialization.unmarshalAsList((InputStream)in);
            }
            catch (Exception e) {
                throw WildFlyCommonExtension.toRuntimeException(e);
            }
            List list = resourceList.getItems();
            Collections.reverse(list);
            list.stream().forEach(r -> System.out.println("Deleting: " + r.getKind() + " name:" + r.getMetadata().getName() + ". Deleted:" + this.getKubernetesClient(context).resource(r).cascading(true).delete()));
        }
    }

    protected void setKubernetesClientInContext(ExtensionContext context, KubernetesClient client) {
        context.getStore(Testing.DEKORATE_STORE).put((Object)"KUBERNETES_CLIENT", (Object)client);
    }

    private WildFlyTestContext getWildFlyTestContext(ExtensionContext context) {
        return (WildFlyTestContext)context.getStore(WILDFLY_STORE).get((Object)KUBERNETES_CONFIG_DATA, WildFlyTestContext.class);
    }

    private void backupAndReplacePlaceholdersInKubernetesYaml(ExtensionContext extensionContext, WildFlyIntegrationTestConfig testConfig) throws IOException {
        if (!Files.exists(this.extensionType.yaml, new LinkOption[0])) {
            return;
        }
        Files.copy(this.extensionType.yaml, this.extensionType.backup, new CopyOption[0]);
        List<String> lines = Files.readAllLines(this.extensionType.yaml, StandardCharsets.UTF_8);
        ArrayList<String> replacedLines = new ArrayList<String>();
        for (String line : lines) {
            line = this.performConfigPlaceholderReplacementForLine(extensionContext, testConfig, line);
            replacedLines.add(line);
        }
        Files.delete(this.extensionType.yaml);
        Files.write(this.extensionType.yaml, replacedLines, new OpenOption[0]);
    }

    public String[] getAdditionalModules(ExtensionContext context) {
        return this.getIntegrationTestConfig(context).getAdditionalModules();
    }

    static RuntimeException toRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw new RuntimeException(throwable);
    }

    private List<ExtraTestSetup> loadAdditionalTestSetups() {
        ServiceLoader<ExtraTestSetup> sl = ServiceLoader.load(ExtraTestSetup.class);
        return sl.stream().map(p -> (ExtraTestSetup)p.get()).collect(Collectors.toList());
    }

    static enum ExtensionType {
        KUBERNETES("kubernetes", "kubectl"),
        OPENSHIFT("openshift", "oc");

        private final Path yaml;
        private final Path backup;
        private final String cliName;

        private ExtensionType(String name, String cliName) {
            String base = "target/classes/META-INF/dekorate/" + name;
            this.yaml = Paths.get(base + ".yml", new String[0]);
            this.backup = Paths.get(base + ".bak", new String[0]);
            this.cliName = cliName;
        }
    }

    private static class Openshift
    extends WildFlyCommonExtension {
        public Openshift() {
            super(ExtensionType.OPENSHIFT);
        }

        @Override
        protected void setNamespace(ExtensionContext context, WildFlyIntegrationTestConfig config, WildFlyTestContext testContext) throws Exception {
        }

        @Override
        protected void deleteNamespace(ExtensionContext context, WildFlyIntegrationTestConfig config, WildFlyTestContext testContext) {
        }
    }

    private static class Kubernetes
    extends WildFlyCommonExtension {
        public Kubernetes() {
            super(ExtensionType.KUBERNETES);
        }

        @Override
        protected void setNamespace(ExtensionContext context, WildFlyIntegrationTestConfig config, WildFlyTestContext testContext) throws Exception {
            if (!config.getNamespace().isBlank()) {
                KubernetesClient client = this.getKubernetesClient(context);
                NonNamespaceOperation namespaceOperation = client.namespaces();
                NamespaceList list = (NamespaceList)namespaceOperation.list();
                boolean foundNs = false;
                for (Namespace namespace : list.getItems()) {
                    if (!namespace.getMetadata().getName().equals(config.getNamespace())) continue;
                    foundNs = true;
                    break;
                }
                if (!foundNs) {
                    Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(config.getNamespace())).endMetadata()).build();
                    System.out.println("Creating namespace " + ns);
                    namespaceOperation.create((Object)ns);
                }
                testContext.setCreatedNamespace(!foundNs);
                new KubernetesNamespaceSwitcher(config.getNamespace()).switchNamespace(context);
            }
        }

        @Override
        protected void deleteNamespace(ExtensionContext context, WildFlyIntegrationTestConfig config, WildFlyTestContext testContext) {
            if (!config.getNamespace().isBlank() && testContext.isCreatedNamespace()) {
                KubernetesClient client = this.getKubernetesClient(context);
                NonNamespaceOperation namespaceOperation = client.namespaces();
                NamespaceList list = (NamespaceList)namespaceOperation.list();
                for (Namespace namespace : list.getItems()) {
                    if (!namespace.getMetadata().getName().equals(config.getNamespace())) continue;
                    namespaceOperation.delete((Object)namespace);
                }
                try {
                    new KubernetesNamespaceSwitcher().resetNamespaceToDefault(context);
                }
                catch (Exception e) {
                    throw Kubernetes.toRuntimeException(e);
                }
            }
        }
    }

    private static class DeploymentGetter
    extends ResourceGetter<Deployment> {
        public DeploymentGetter(KubernetesClient client, Resource resource) {
            super(client, resource);
        }

        @Override
        Deployment getResource() {
            return (Deployment)((RollableScalableResource)this.client.apps().deployments().withName(this.resource.name())).get();
        }
    }

    private static abstract class ResourceGetter<T extends HasMetadata> {
        protected final KubernetesClient client;
        protected Resource resource;

        public ResourceGetter(KubernetesClient client, Resource resource) {
            this.client = client;
            this.resource = resource;
        }

        abstract T getResource();

        static ResourceGetter create(KubernetesClient client, Resource resource) {
            switch (resource.type()) {
                case DEPLOYMENT: {
                    return new DeploymentGetter(client, resource);
                }
            }
            throw new IllegalStateException("Unhandled resource type " + resource.type());
        }
    }

    private static class StreamReader
    implements Runnable {
        private final BufferedReader in;
        private final PrintStream out;

        public StreamReader(InputStream in, PrintStream out) {
            this.in = new BufferedReader(new InputStreamReader(in));
            this.out = out;
        }

        @Override
        public void run() {
            try {
                String line = this.in.readLine();
                while (line != null) {
                    this.out.println(line);
                    line = this.in.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class KubernetesNamespaceSwitcher {
        private final String namespace;

        KubernetesNamespaceSwitcher() {
            this("default");
        }

        public KubernetesNamespaceSwitcher(String namespace) {
            this.namespace = namespace;
        }

        void switchNamespace(ExtensionContext context) throws Exception {
            this.switchKubeCtlNamespace();
            KubernetesClient client = WildFlyCommonExtension.this.getKubernetesClient(context);
            Config namespaceConfig = ((ConfigBuilder)new ConfigBuilder(client.getConfiguration()).withNamespace(this.namespace)).build();
            KubernetesClientImpl namespacedClient = new KubernetesClientImpl(client.getHttpClient(), namespaceConfig);
            WildFlyCommonExtension.this.getWildFlyTestContext(context).setOriginalClient(client);
            WildFlyCommonExtension.this.setKubernetesClientInContext(context, (KubernetesClient)namespacedClient);
        }

        public void resetNamespaceToDefault(ExtensionContext context) throws Exception {
            this.switchKubeCtlNamespace();
            KubernetesClient client = WildFlyCommonExtension.this.getKubernetesClient(context);
            WildFlyCommonExtension.this.setKubernetesClientInContext(context, WildFlyCommonExtension.this.getWildFlyTestContext(context).getOriginalClient());
            client.close();
        }

        private void switchKubeCtlNamespace() throws Exception {
            System.out.println("Switching namespace to " + this.namespace);
            ProcessBuilder pb = new ProcessBuilder(WildFlyCommonExtension.this.extensionType.cliName, "config", "set-context", "--current", "--namespace=" + this.namespace);
            Process process = pb.start();
            ExecutorService executor = Executors.newFixedThreadPool(2);
            executor.submit(new StreamReader(process.getInputStream(), System.out));
            executor.submit(new StreamReader(process.getErrorStream(), System.err));
            int exit = process.waitFor();
            if (exit != 0) {
                throw new IllegalStateException("Error changing namespace to " + this.namespace);
            }
        }
    }

    private static class WildFlyTestContext {
        private String useNamespace;
        private boolean createdNamespace;
        private KubernetesClient originalClient;
        private TestHelper helper;

        private WildFlyTestContext() {
        }

        public String getUseNamespace() {
            return this.useNamespace;
        }

        public void setUseNamespace(String useNamespace) {
            this.useNamespace = useNamespace;
        }

        public boolean isCreatedNamespace() {
            return this.createdNamespace;
        }

        public void setCreatedNamespace(boolean createdNamespace) {
            this.createdNamespace = createdNamespace;
        }

        public void setOriginalClient(KubernetesClient client) {
            this.originalClient = client;
        }

        public KubernetesClient getOriginalClient() {
            return this.originalClient;
        }

        void setHelper(TestHelper helper) {
            this.helper = helper;
        }

        TestHelper getHelper() {
            return this.helper;
        }
    }
}

