/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.cloud.common;

import java.lang.annotation.Annotation;
import org.wildfly.test.cloud.common.Resource;

public @interface KubernetesResource {
    public String definitionLocation();

    public Resource[] additionalResourcesCreated() default {};

    public long readinessTimeout() default 500000L;

    public static class Literal
    implements KubernetesResource {
        private Resource[] additionalResourcesCreated = new Resource[0];
        private long readinessTimeout = 50000L;
        private String definitionLocation;

        @Override
        public Class<? extends Annotation> annotationType() {
            return KubernetesResource.class;
        }

        @Override
        public String definitionLocation() {
            return this.definitionLocation;
        }

        @Override
        public Resource[] additionalResourcesCreated() {
            return new Resource[0];
        }

        @Override
        public long readinessTimeout() {
            return this.readinessTimeout;
        }

        public Literal withDefinitionLocation(String definitionLocation) {
            this.definitionLocation = definitionLocation;
            return this;
        }

        public Literal withReadinessTimeout(long readinessTimeout) {
            this.readinessTimeout = readinessTimeout;
            return this;
        }

        public Literal withAdditionalResourcesCreated(Resource ... additionalResourcesCreated) {
            Resource[] tmp = new Resource[this.additionalResourcesCreated.length + additionalResourcesCreated.length];
            System.arraycopy(this.additionalResourcesCreated, 0, tmp, 0, this.additionalResourcesCreated.length);
            System.arraycopy(additionalResourcesCreated, 0, tmp, this.additionalResourcesCreated.length, additionalResourcesCreated.length);
            this.additionalResourcesCreated = additionalResourcesCreated;
            return this;
        }
    }
}

