/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.spi.AuthorizationPolicy;
import org.apache.camel.spi.RouteContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.wildfly.extension.camel.security.DomainPrincipal;
import org.wildfly.extension.camel.security.UsernamePasswordPrincipal;

public abstract class AbstractAuthorizationPolicy
implements AuthorizationPolicy {
    public void beforeWrap(RouteContext routeContext, NamedNode definition) {
    }

    public Processor wrap(RouteContext routeContext, final Processor processor) {
        return new Processor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Exchange exchange) throws Exception {
                Subject subject = (Subject)exchange.getIn().getHeader("CamelAuthentication", Subject.class);
                if (subject == null) {
                    throw new SecurityException("Cannot obtain authentication subject from exchange: " + exchange);
                }
                String domain = null;
                String username = null;
                char[] password = null;
                for (Principal principal : subject.getPrincipals()) {
                    if (principal instanceof UsernamePasswordPrincipal) {
                        username = principal.getName();
                        password = ((UsernamePasswordPrincipal)principal).getPassword();
                        continue;
                    }
                    if (principal instanceof DomainPrincipal) {
                        domain = principal.getName();
                        continue;
                    }
                    if (!(principal instanceof UsernamePasswordAuthenticationToken)) continue;
                    username = principal.getName();
                    Object credentials = ((UsernamePasswordAuthenticationToken)principal).getCredentials();
                    if (credentials instanceof String) {
                        password = ((String)credentials).toCharArray();
                        continue;
                    }
                    if (!(credentials instanceof char[])) continue;
                    password = (char[])credentials;
                }
                if (username == null || password == null) {
                    throw new SecurityException("Cannot obtain credentials from exchange: " + exchange);
                }
                LoginContext context = AbstractAuthorizationPolicy.this.getLoginContext(domain, username, password);
                context.login();
                try {
                    AbstractAuthorizationPolicy.this.authorize(context);
                    processor.process(exchange);
                }
                finally {
                    context.logout();
                }
            }
        };
    }

    protected void authorize(LoginContext context) throws LoginException {
    }

    protected abstract LoginContext getLoginContext(String var1, String var2, char[] var3) throws LoginException;
}

