/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.utils;

import java.net.URL;
import java.util.List;
import org.apache.camel.spring.SpringCamelContext;
import org.wildfly.camel.utils.IllegalStateAssertion;
import org.wildfly.camel.utils.SpringCamelContextBootstrap;

public final class SpringCamelContextFactory {
    private SpringCamelContextFactory() {
    }

    public static SpringCamelContext createSingleCamelContext(URL contextUrl, ClassLoader classsLoader) throws Exception {
        SpringCamelContextBootstrap bootstrap = new SpringCamelContextBootstrap(contextUrl, classsLoader);
        List<SpringCamelContext> list = bootstrap.createSpringCamelContexts();
        IllegalStateAssertion.assertEquals(1, list.size(), "Single context expected in: " + contextUrl);
        return list.get(0);
    }

    public static List<SpringCamelContext> createCamelContextList(URL contextUrl, ClassLoader classsLoader) throws Exception {
        SpringCamelContextBootstrap bootstrap = new SpringCamelContextBootstrap(contextUrl, classsLoader);
        return bootstrap.createSpringCamelContexts();
    }

    public static List<SpringCamelContext> createCamelContextList(byte[] bytes, ClassLoader classsLoader) throws Exception {
        SpringCamelContextBootstrap bootstrap = new SpringCamelContextBootstrap(bytes, classsLoader);
        return bootstrap.createSpringCamelContexts();
    }
}

