/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpRequest {
    public static String get(String spec, long timeout, TimeUnit unit) throws IOException, ExecutionException, TimeoutException {
        final URL url = new URL(spec);
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                return HttpRequest.processResponse(conn);
            }
        };
        return HttpRequest.execute(task, timeout, unit);
    }

    public static String get(String spec, final InputStream inputStream, long timeout, TimeUnit unit) throws TimeoutException, IOException {
        final URL url = new URL(spec);
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                HttpRequest.copy(inputStream, conn.getOutputStream());
                return HttpRequest.processResponse(conn);
            }
        };
        return HttpRequest.execute(task, timeout, unit);
    }

    private static String execute(Callable<String> task, long timeout, TimeUnit unit) throws TimeoutException, IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> result = executor.submit(task);
        try {
            String string = result.get(timeout, unit);
            return string;
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        finally {
            executor.shutdownNow();
            try {
                executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {}
        }
    }

    private static String read(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out) throws IOException {
        int c = 0;
        try {
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processResponse(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            InputStream err = conn.getErrorStream();
            try {
                throw new IOException(HttpRequest.read(err));
            }
            catch (Throwable throwable) {
                err.close();
                throw throwable;
            }
        }
        try (InputStream in = conn.getInputStream();){
            String string = HttpRequest.read(in);
            return string;
        }
    }
}

