/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce4.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.tinymce4.TinyMceBehavior;
import wicket.contrib.tinymce4.settings.Enum;
import wicket.contrib.tinymce4.settings.Toolbar;

public class TinyMCESettings
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(TinyMCESettings.class);
    public static final ResourceReference TINYMCE_JS_REF = new JavaScriptResourceReference(TinyMceBehavior.class, "tinymce/tinymce.js");
    public static final ResourceReference TINYMCE_JS_REF_MIN = new JavaScriptResourceReference(TinyMceBehavior.class, "tinymce/tinymce.min.js");
    private Theme theme;
    private Language language;
    private Boolean resizing = false;
    private Boolean readOnly = false;
    private Boolean menuBar = true;
    private Boolean inLine = false;
    private Boolean convertUrls = null;
    private Boolean removeScriptHost = null;
    private Boolean relativeUrls = null;
    private String blockFormats = null;
    private ResourceReference contentCss = null;
    private String documentBaseUrl;
    private final List<String> plugins;
    private final List<String> customSettings;
    private final List<Toolbar> toolbars;

    public TinyMCESettings() {
        this(Theme.modern);
    }

    public TinyMCESettings(Theme theme) {
        this(theme, TinyMCESettings.selectLang());
    }

    public TinyMCESettings(Theme theme, Language lang) {
        this.theme = theme;
        this.language = lang;
        this.plugins = new ArrayList<String>();
        this.customSettings = new ArrayList<String>();
        this.toolbars = new ArrayList<Toolbar>();
    }

    private static Language selectLang() {
        return Language.fromLocale(Session.get().getLocale());
    }

    public Theme getTheme() {
        return this.theme;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getDocumentBaseUrl() {
        return this.documentBaseUrl;
    }

    public TinyMCESettings setDocumentBaseUrl(String documentBaseUrl) {
        this.documentBaseUrl = documentBaseUrl;
        return this;
    }

    public TinyMCESettings addCustomSetting(String customSetting) {
        this.customSettings.add(customSetting);
        return this;
    }

    public String[] getCustomSettings() {
        return this.customSettings.toArray(new String[this.customSettings.size()]);
    }

    public ResourceReference getContentCss() {
        return this.contentCss;
    }

    public TinyMCESettings setContentCss(ResourceReference contentCss) {
        this.contentCss = contentCss;
        return this;
    }

    public String getBlockFormats() {
        return this.blockFormats;
    }

    public TinyMCESettings setBlockFormats(String blockFormats) {
        this.blockFormats = blockFormats;
        return this;
    }

    public TinyMCESettings setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public TinyMCESettings setResizing(Boolean resizing) {
        this.resizing = resizing;
        return this;
    }

    public Boolean getResizing() {
        return this.resizing;
    }

    public TinyMCESettings setConvertUrls(boolean convertUrls) {
        this.convertUrls = convertUrls;
        return this;
    }

    public Boolean getConvertUrls() {
        return this.convertUrls;
    }

    public TinyMCESettings setRemoveScriptHost(Boolean removeScriptHost) {
        this.removeScriptHost = removeScriptHost;
        return this;
    }

    public Boolean getRemoveScriptHost() {
        return this.removeScriptHost;
    }

    public TinyMCESettings setRelativeUrls(Boolean relativeUrls) {
        this.relativeUrls = relativeUrls;
        return this;
    }

    public Boolean getRelativeUrls() {
        return this.relativeUrls;
    }

    public final String toJavaScript(Mode mode, Collection<Component> components) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n\t").append("mode").append(" : ").append('\"').append(mode.getName()).append('\"');
        if (Mode.exact.equals(mode)) {
            this.addElements(components, buffer);
        }
        if (this.language != null) {
            TinyMCESettings.appendSingleConfigElement(buffer, "language", this.language.toString(), true);
        }
        TinyMCESettings.appendSingleConfigElement(buffer, "theme", this.theme.getName(), true);
        buffer.append(this.toJavaScript());
        return buffer.toString();
    }

    public String toJavaScript() {
        StringBuffer buffer = new StringBuffer();
        if (this.convertUrls != null) {
            TinyMCESettings.appendSingleConfigElement(buffer, "convert_urls", Boolean.toString(this.convertUrls));
        }
        if (this.relativeUrls != null) {
            TinyMCESettings.appendSingleConfigElement(buffer, "relative_urls", Boolean.toString(this.relativeUrls));
        }
        if (this.removeScriptHost != null) {
            TinyMCESettings.appendSingleConfigElement(buffer, "remove_script_host", Boolean.toString(this.removeScriptHost));
        }
        if (this.readOnly.booleanValue()) {
            TinyMCESettings.appendSingleConfigElement(buffer, "readonly", "true");
        }
        if (this.contentCss != null) {
            String contentCssUrl = RequestCycle.get().urlFor(this.contentCss, null).toString();
            TinyMCESettings.appendSingleConfigElement(buffer, "content_css", contentCssUrl, true);
        }
        if (this.documentBaseUrl != null) {
            TinyMCESettings.appendSingleConfigElement(buffer, "document_base_url", this.documentBaseUrl, true);
        }
        if (!this.menuBar.booleanValue()) {
            TinyMCESettings.appendSingleConfigElement(buffer, "menubar", "false");
        }
        if (this.inLine.booleanValue()) {
            TinyMCESettings.appendSingleConfigElement(buffer, "inline", "true");
        }
        this.appendPluginsSettings(buffer);
        this.appendToolbarsSettings(buffer);
        this.appendCustomSettings(buffer);
        return buffer.toString();
    }

    private void appendPluginsSettings(StringBuffer buffer) {
        if (this.plugins.size() < 1) {
            return;
        }
        buffer.append(",\n\t").append("plugins: [\n\"");
        for (String plugin : this.plugins) {
            buffer.append(plugin).append(' ');
        }
        buffer.append("\"\n]");
    }

    private void appendToolbarsSettings(StringBuffer buffer) {
        for (Toolbar toolbar : this.toolbars) {
            TinyMCESettings.appendSingleConfigElement(buffer, toolbar.getId(), toolbar.toString(), true);
        }
    }

    private void appendCustomSettings(StringBuffer buffer) {
        for (String line : this.customSettings) {
            buffer.append(",\n\t").append(line);
        }
    }

    private void addElements(Collection<Component> components, StringBuffer buffer) {
        if (components.size() > 0) {
            buffer.append(",\n\telements : \"");
            Iterator<Component> iterator = components.iterator();
            while (iterator.hasNext()) {
                Component component = iterator.next();
                buffer.append(component.getMarkupId());
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append("\"");
        } else {
            LOG.warn("tinymce is set to \"exact\" mode but there are no components attached");
        }
    }

    public TinyMCESettings addPlugins(String pluginName) {
        this.plugins.add(pluginName);
        return this;
    }

    public TinyMCESettings addToolbar(Toolbar toolbar) {
        this.toolbars.add(toolbar);
        return this;
    }

    public Boolean getMenuBar() {
        return this.menuBar;
    }

    public TinyMCESettings setMenuBar(Boolean menuBar) {
        this.menuBar = menuBar;
        return this;
    }

    public static void appendSingleConfigElement(StringBuffer buffer, String name, String value) {
        TinyMCESettings.appendSingleConfigElement(buffer, name, value, false);
    }

    public static void appendSingleConfigElement(StringBuffer buffer, String name, String value, boolean wrapValueWithQuotes) {
        String quotes = wrapValueWithQuotes ? "\"" : "";
        buffer.append(",\n\t").append(name).append(" : ").append(quotes).append(value).append(quotes);
    }

    public Boolean getInLine() {
        return this.inLine;
    }

    public TinyMCESettings setInLine(Boolean inLine) {
        this.inLine = inLine;
        return this;
    }

    public static class Theme
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Theme modern = new Theme("modern");

        private Theme(String name) {
            super(name);
        }
    }

    public static enum Language {
        ar,
        ar_SA,
        az,
        be,
        bg_BG,
        bn_BD,
        bs,
        ca,
        cs,
        cs_CZ,
        cy,
        da,
        de,
        de_AT,
        dv,
        el,
        en_CA,
        en_GB,
        eo,
        es,
        es_MX,
        et,
        eu,
        fa,
        fa_IR,
        fi,
        fo,
        fr_CH,
        fr_FR,
        ga,
        gd,
        gl,
        he_IL,
        hi_IN,
        hr,
        hu_HU,
        hy,
        id,
        is_IS,
        it,
        ja,
        ka_GE,
        kab,
        kk,
        km_KH,
        ko,
        ko_KR,
        ku,
        ku_IQ,
        lb,
        lt,
        lv,
        mk_MK,
        ml,
        ml_IN,
        mn_MN,
        nb_NO,
        nl,
        pl,
        pt_BR,
        pt_PT,
        ro,
        ru,
        ru_RU,
        si_LK,
        sk,
        sl_SI,
        sr,
        sv_SE,
        ta,
        ta_IN,
        tg,
        th_TH,
        tr,
        tr_TR,
        tt,
        ug,
        uk,
        uk_UA,
        vi,
        vi_VN,
        zh_CN,
        zh_TW;

        private static final Map<String, Language> unmappedLocales;

        public static Language fromLocale(Locale locale) {
            Language language = Language.fromString(locale.getLanguage() + "_" + locale.getCountry());
            if (language != null) {
                return language;
            }
            language = Language.fromString(locale.getLanguage());
            if (language != null) {
                return language;
            }
            language = Language.fromString(locale.getISO3Language());
            if (language != null) {
                return language;
            }
            return unmappedLocales.get(locale.getLanguage());
        }

        private static Language fromString(String string) {
            try {
                return Language.valueOf(string);
            }
            catch (Exception e) {
                return null;
            }
        }

        static {
            unmappedLocales = new HashMap<String, Language>();
            unmappedLocales.put("bg", bg_BG);
            unmappedLocales.put("en", en_GB);
            unmappedLocales.put("fr", fr_FR);
            unmappedLocales.put("hi", hi_IN);
            unmappedLocales.put("hu", hu_HU);
            unmappedLocales.put("is", is_IS);
            unmappedLocales.put("iw", he_IL);
            unmappedLocales.put("mk", mk_MK);
            unmappedLocales.put("nb", nb_NO);
            unmappedLocales.put("no", nb_NO);
            unmappedLocales.put("pt", pt_PT);
            unmappedLocales.put("sl", sl_SI);
            unmappedLocales.put("sv", sv_SE);
            unmappedLocales.put("th", th_TH);
            unmappedLocales.put("zh", zh_CN);
        }
    }

    public static class Mode
    extends Enum {
        private static final long serialVersionUID = 1L;
        public static final Mode none = new Mode("none");
        public static final Mode exact = new Mode("exact");

        private Mode(String name) {
            super(name);
        }
    }
}

