/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce4.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalDialog;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.tinymce4.image.FileResourceStream;
import wicket.contrib.tinymce4.image.ImageFileDescription;
import wicket.contrib.tinymce4.image.ImageUploadContentPanel;
import wicket.contrib.tinymce4.image.ImageUploadHelper;

public class ImageUploadPanel
extends Panel
implements IRequestListener {
    private static final long serialVersionUID = -5848356532326545817L;
    private static final Logger log = LoggerFactory.getLogger(ImageUploadPanel.class);
    private static final ResourceReference IMAGE_UPLOAD_JS_RESOURCE = new JavaScriptResourceReference(ImageUploadPanel.class, "imageUpload.js");
    private static final ResourceReference IMAGE_UPLOAD_CSS_RESOURCE = new CssResourceReference(ImageUploadPanel.class, "imageUpload.css");
    private ModalDialog modalWindow;
    private ImageUploadBehavior imageUploadBehavior;
    private final String uploadFolderPath;

    public ImageUploadPanel(String pId, String uploadFolderPath) {
        super(pId);
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.modalWindow = new ModalDialog("imageUploadDialog"){

            public ModalDialog close(AjaxRequestTarget target) {
                ImageUploadPanel.this.resetModalContent();
                return super.close(target);
            }
        };
        componentArray[0] = this.modalWindow;
        this.add(componentArray);
        Behavior[] behaviorArray = new Behavior[1];
        this.imageUploadBehavior = new ImageUploadBehavior();
        behaviorArray[0] = this.imageUploadBehavior;
        this.add(behaviorArray);
        this.uploadFolderPath = uploadFolderPath;
    }

    public ImageUploadPanel(String pId) {
        this(pId, ImageUploadHelper.getTemporaryDirPath());
    }

    public void resetModalContent() {
        this.modalWindow.setContent((Component)new EmptyPanel("content"));
    }

    public void onRequest() {
        String fileName = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("filename").toString();
        if (Strings.isEmpty((String)fileName)) {
            log.warn("There is no file name of image");
            return;
        }
        String contentType = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("contenttype").toString();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.uploadFolderPath + File.separatorChar + fileName);
        }
        catch (FileNotFoundException ex) {
            log.error("Problem with getting image - " + ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("Problem with getting image");
        }
        RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler((IResourceStream)new FileResourceStream(contentType, inputStream)));
    }

    public ImageUploadBehavior getImageUploadBehavior() {
        return this.imageUploadBehavior;
    }

    public class ImageUploadBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 7786779421116467886L;

        protected void respond(AjaxRequestTarget pTarget) {
            ImageUploadContentPanel content = new ImageUploadContentPanel("content", ImageUploadPanel.this.uploadFolderPath){
                private static final long serialVersionUID = 1L;

                @Override
                public void onImageUploaded(ImageFileDescription pImageFileDescription, AjaxRequestTarget pTarget) {
                    ImageUploadPanel.this.modalWindow.close(pTarget);
                    ImageUploadPanel.this.resetModalContent();
                    CharSequence url = ImageUploadPanel.this.urlForListener(new PageParameters());
                    XmlTag xmlImageTag = ImageUploadHelper.createImageTag(pImageFileDescription, url);
                    pTarget.appendJavaScript((CharSequence)("putImage('" + xmlImageTag.toString() + "');"));
                }
            };
            ImageUploadPanel.this.modalWindow.setContent((Component)content);
            pTarget.appendJavaScript((CharSequence)"saveBookmark();");
            ImageUploadPanel.this.modalWindow.open(pTarget);
        }

        public String getCallbackName() {
            return "showImageUploadDialog";
        }

        public void renderHead(Component c, IHeaderResponse pResponse) {
            String script = this.getCallbackName() + " = function () { if(isImgSelected())openImageForm(); else " + this.getCallbackScript() + "; }";
            pResponse.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
            pResponse.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)IMAGE_UPLOAD_JS_RESOURCE));
            pResponse.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)IMAGE_UPLOAD_CSS_RESOURCE));
        }
    }
}

