/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.tinymce4.image;

import jakarta.servlet.ServletContext;
import java.io.File;
import org.apache.wicket.Session;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.cycle.RequestCycle;
import wicket.contrib.tinymce4.image.ImageFileDescription;

public class ImageUploadHelper {
    public static final String IMAGE_CONTENT_TYPE = "contenttype";
    public static final String IMAGE_FILE_NAME = "filename";

    private ImageUploadHelper() {
        throw new UnsupportedOperationException("You are not allowed to create an instance of this class");
    }

    public static String getTemporaryDirPath() {
        ServletContext servletContext = WebApplication.get().getServletContext();
        return ((File)servletContext.getAttribute("javax.servlet.context.tempdir")).getPath() + File.separatorChar + Session.get().getId() + File.separatorChar;
    }

    public static XmlTag createImageTag(ImageFileDescription pImageFileDescription, CharSequence pUrl) {
        XmlTag tag = new XmlTag();
        tag.setName("img");
        tag.setType(XmlTag.TagType.OPEN_CLOSE);
        tag.put(IMAGE_FILE_NAME, (CharSequence)pImageFileDescription.getName());
        StringBuilder sb = new StringBuilder(pUrl);
        sb.append("&").append(IMAGE_FILE_NAME).append("=").append(pImageFileDescription.getName());
        sb.append("&").append(IMAGE_CONTENT_TYPE).append("=").append(pImageFileDescription.getContentType());
        tag.put("src", (CharSequence)RequestCycle.get().getOriginalResponse().encodeURL((CharSequence)sb.toString()));
        return tag;
    }
}

