/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.wicket.page.store;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.io.IClusterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCache
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PageCache.class);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock read = this.rwl.readLock();
    private final Lock write = this.rwl.writeLock();
    private final LinkedHashMap<Integer, SerializedPage> pages = new LinkedHashMap();
    private final TreeMap<Integer, Integer> pageKeys = new TreeMap();
    private final AtomicInteger id = new AtomicInteger(Integer.MIN_VALUE);
    private final int MAX_SIZE;

    public PageCache(int maxSize) {
        this.MAX_SIZE = maxSize;
    }

    public boolean containsPage(int pageId) {
        this.read.lock();
        try {
            boolean bl = this.pageKeys.containsKey(pageId);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    public SerializedPage getPage(int pageId) {
        this.read.lock();
        try {
            SerializedPage serializedPage = this.pages.get(pageId);
            return serializedPage;
        }
        finally {
            this.read.unlock();
        }
    }

    public void removePage(Integer pageId) {
        this.write.lock();
        try {
            this.pages.remove(pageId);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePages(SerializedPage wrapper) {
        this.write.lock();
        try {
            int numToRemove;
            if (this.MAX_SIZE != -1 && (numToRemove = this.pages.size() + 1 - this.MAX_SIZE) > 0) {
                Iterator<Map.Entry<Integer, SerializedPage>> iter = this.pages.entrySet().iterator();
                while (iter.hasNext() && numToRemove > 0) {
                    Map.Entry<Integer, SerializedPage> entry = iter.next();
                    iter.remove();
                    this.pageKeys.remove(entry.getKey());
                    --numToRemove;
                }
            }
            Integer pageKey = wrapper.getPageId();
            this.pages.remove(pageKey);
            this.pages.put(pageKey, wrapper);
            this.pageKeys.put(pageKey, this.id.getAndIncrement());
        }
        finally {
            this.write.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, SerializedPage> entry : this.pages.entrySet()) {
            sb.append("\t").append(entry.getKey().toString()).append("\n");
        }
        if (LOG.isTraceEnabled()) {
            sb.append("\tPageKeys TreeSet: ").append(this.pageKeys.toString());
        }
        return sb.toString();
    }
}

