/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.page;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LogoutPage.class);
    public static final String REDIRECTPAGE_PARAM = "redirectpage";

    public LogoutPage(CharSequence url) {
        this.doLogoutAndAddRedirect(url, this.getDelayTime());
    }

    public LogoutPage(Class<? extends Page> pageClass) {
        this.doLogoutAndAddRedirect(this.urlFor(pageClass, null), this.getDelayTime());
    }

    public LogoutPage(PageParameters parameters) {
        Class<?> pageClass;
        StringValue page = parameters.get(REDIRECTPAGE_PARAM);
        if (!page.isNull()) {
            try {
                pageClass = Class.forName(page.toString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            pageClass = this.getApplication().getHomePage();
        }
        this.setStatelessHint(true);
        this.setResponsePage(pageClass);
        Subject subject = SecurityUtils.getSubject();
        LOG.info("logout: " + subject);
        subject.logout();
    }

    private void doLogoutAndAddRedirect(CharSequence url, int waitBeforeRedirectInSeconds) {
        this.setStatelessHint(true);
        Subject subject = SecurityUtils.getSubject();
        LOG.info("logout: " + subject);
        subject.logout();
        WebMarkupContainer redirect = new WebMarkupContainer("redirect");
        String content = waitBeforeRedirectInSeconds + ";URL=" + url;
        redirect.add(new Behavior[]{new AttributeModifier("content", (IModel)new Model((Serializable)((Object)content)))});
        this.add(new Component[]{redirect});
        Cookie c = new Cookie("rememberMe", "xxx");
        c.setMaxAge(0);
        ((WebResponse)RequestCycle.get().getResponse()).addCookie(c);
    }

    public int getDelayTime() {
        return 0;
    }

    public boolean isVersioned() {
        return false;
    }
}

