/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.wicket.page.store;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPersistentPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.shiro.wicket.page.store.PageCacheManager;

public class SessionPageStore
extends AbstractPersistentPageStore {
    private static final Logger LOG = LoggerFactory.getLogger(SessionPageStore.class);
    private static final String PAGE_MAP_SESSION_KEY = SessionPageStore.class.getName() + "_PAGE_CACHE_MANAGER_SESSION_KEY";
    protected static final int DEFAULT_MAX_PAGES = -1;
    private final int MAX_PAGE_MAP_SIZE;

    public SessionPageStore(String applicationName) {
        this(applicationName, -1);
    }

    public SessionPageStore(String applicationName, int maxPageMapSize) {
        super(applicationName);
        if (maxPageMapSize < -1) {
            this.MAX_PAGE_MAP_SIZE = -1;
            LOG.info("Created SessionPageStore: unlimited number of pages allowed.");
        } else {
            this.MAX_PAGE_MAP_SIZE = maxPageMapSize;
            LOG.info("Created SessionPageStore: [{}] maximum number of pages allowed.", (Object)maxPageMapSize);
        }
    }

    public int getMaxPageMapSize() {
        return this.MAX_PAGE_MAP_SIZE;
    }

    public boolean supportsVersioning() {
        return true;
    }

    protected IManageablePage getPersistedPage(String sessionIdentifier, int pageId) {
        Session session = this.getSession(sessionIdentifier, false);
        if (session != null) {
            return this.getPageCacheManager(session).getPageCache().getPage(pageId);
        }
        return null;
    }

    protected void removePersistedPage(String sessionIdentifier, IManageablePage page) {
        LOG.debug("Removing page with id [{}]", (Object)page.getPageId());
        Session session = this.getSession(sessionIdentifier, false);
        if (session != null) {
            this.getPageCacheManager(session).getPageCache().removePage(page.getPageId());
        }
    }

    protected void addPersistedPage(String sessionIdentifier, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("DiskPageStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        Session session = this.getSession(sessionIdentifier, true);
        this.getPageCacheManager(session).getPageCache().storePages(serializedPage);
        if (LOG.isDebugEnabled()) {
            LOG.debug("storePage {}", (Object)serializedPage.toString());
        }
    }

    protected void removeAllPersistedPages(String sessionIdentifier) {
        Object existing;
        Session session = this.getSession(sessionIdentifier, false);
        if (session != null && (existing = session.removeAttribute((Object)PAGE_MAP_SESSION_KEY)) != null) {
            LOG.debug("Removed PageMap [{}] from the Session (destroying)", existing);
        }
    }

    protected PageCacheManager getPageCacheManager(Session session) {
        PageCacheManager pcc = (PageCacheManager)session.getAttribute((Object)PAGE_MAP_SESSION_KEY);
        if (pcc == null) {
            pcc = new PageCacheManager(this.getMaxPageMapSize());
            session.setAttribute((Object)PAGE_MAP_SESSION_KEY, (Object)pcc);
        }
        return pcc;
    }

    protected Session getSession(String sessionIdentifier, boolean create) {
        Session session = null;
        Subject currentSubject = SecurityUtils.getSubject();
        if (currentSubject != null && (session = currentSubject.getSession(create)) != null && sessionIdentifier != null && !sessionIdentifier.equals(session.getId())) {
            throw new WicketRuntimeException("The specified Wicket sessionId [" + sessionIdentifier + "] is not the same as Shiro's current Subject Session with id [" + session.getId() + "], indicating the Wicket request's session is not the same as Shiro's current Subject Session. The two must always be equal when using the " + ((Object)((Object)this)).getClass().getName() + " implementation. If you're seeing this exception, ensure you have configured Shiro to use Enterprise Sessions and not (the default) HTTP-only Sessions.");
        }
        return session;
    }
}

