/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.shiro.ShiroAction;
import org.wicketstuff.shiro.annotation.ShiroSecurityConstraint;
import org.wicketstuff.shiro.annotation.ShiroSecurityConstraints;

public class AnnotationsShiroAuthorizationStrategy
implements IAuthorizationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationsShiroAuthorizationStrategy.class);

    protected ShiroSecurityConstraint checkInvalidInstantiation(Annotation[] annotations, ShiroAction action) {
        if (annotations == null) {
            return null;
        }
        block6: for (Annotation annotation : annotations) {
            ShiroSecurityConstraint constraint;
            if (!(annotation instanceof ShiroSecurityConstraint) || action != (constraint = (ShiroSecurityConstraint)annotation).action()) continue;
            Subject subject = SecurityUtils.getSubject();
            switch (constraint.constraint()) {
                case HasRole: {
                    if (subject.hasRole(constraint.value())) continue block6;
                    return constraint;
                }
                case HasPermission: {
                    if (subject.isPermitted(constraint.value())) continue block6;
                    return constraint;
                }
                case IsAuthenticated: {
                    if (subject.isAuthenticated()) continue block6;
                    return constraint;
                }
                case LoggedIn: {
                    if (subject.getPrincipal() != null) continue block6;
                    return constraint;
                }
            }
        }
        return null;
    }

    public <T extends IRequestableComponent> ShiroSecurityConstraint checkInvalidInstantiation(Class<T> componentClass) {
        Annotation[] componentClassAnnotations = componentClass.getAnnotations();
        ShiroSecurityConstraint fail = this.checkInvalidInstantiation(this.findShiroSecurityConstraintAnnotations(componentClassAnnotations), ShiroAction.INSTANTIATE);
        if (fail == null) {
            Annotation[] packageAnnotations = componentClass.getPackage().getAnnotations();
            fail = this.checkInvalidInstantiation(this.findShiroSecurityConstraintAnnotations(packageAnnotations), ShiroAction.INSTANTIATE);
        }
        return fail;
    }

    public boolean isActionAuthorized(Component component, Action action) {
        ShiroAction _action = action.getName().equals("RENDER") ? ShiroAction.RENDER : ShiroAction.ENABLE;
        Class<?> clazz = component.getClass();
        Annotation[] componentClassAnnotations = clazz.getAnnotations();
        ShiroSecurityConstraint fail = this.checkInvalidInstantiation(this.findShiroSecurityConstraintAnnotations(componentClassAnnotations), _action);
        if (fail == null) {
            Annotation[] packageAnnotations = clazz.getPackage().getAnnotations();
            fail = this.checkInvalidInstantiation(this.findShiroSecurityConstraintAnnotations(packageAnnotations), _action);
        }
        return fail == null;
    }

    public boolean isResourceAuthorized(IResource resource, PageParameters parameters) {
        return true;
    }

    public <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
        ShiroSecurityConstraint fail = this.checkInvalidInstantiation(componentClass);
        if (fail != null) {
            LOG.info("Unauthorized Instantiation :: component={} reason={} subject={}", new Object[]{componentClass, fail, SecurityUtils.getSubject()});
            return false;
        }
        return true;
    }

    private ShiroSecurityConstraint[] findShiroSecurityConstraintAnnotations(Annotation[] componentClassAnnotations) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation annotation : componentClassAnnotations) {
            if (annotation instanceof ShiroSecurityConstraint) {
                annotations.add(annotation);
                continue;
            }
            if (!(annotation instanceof ShiroSecurityConstraints)) continue;
            annotations.addAll(Arrays.asList(((ShiroSecurityConstraints)annotation).value()));
        }
        return annotations.toArray(new ShiroSecurityConstraint[annotations.size()]);
    }
}

