/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.component;

import java.io.Serializable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.value.ValueMap;

public class LoginPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private boolean includeRememberMe = true;
    private PasswordTextField password;
    private boolean rememberMe = true;
    private TextField<String> username;

    public LoginPanel(String id) {
        this(id, true);
    }

    public LoginPanel(String id, boolean includeRememberMe) {
        super(id);
        this.includeRememberMe = includeRememberMe;
        if (!includeRememberMe) {
            this.rememberMe = false;
        }
        this.add(new Component[]{new FeedbackPanel("feedback")});
        this.add(new Component[]{new SignInForm("signInForm")});
    }

    public String getPassword() {
        return this.password.getInput();
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }

    public String getUsername() {
        return this.username.getDefaultModelObjectAsString();
    }

    public boolean login(String username, String password, boolean rememberMe) {
        Subject currentUser = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, password, rememberMe);
        try {
            currentUser.login((AuthenticationToken)token);
            return true;
        }
        catch (IncorrectCredentialsException ice) {
            this.error((Serializable)((Object)"Password is incorrect."));
        }
        catch (UnknownAccountException uae) {
            this.error((Serializable)((Object)"There is no account with that username."));
        }
        catch (AuthenticationException ae) {
            this.error((Serializable)((Object)"Invalid username and/or password."));
        }
        catch (Exception ex) {
            this.error((Serializable)((Object)"Login failed"));
        }
        return false;
    }

    protected void onSignInSucceeded() {
        this.continueToOriginalDestination();
        this.setResponsePage(this.getApplication().getHomePage());
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public final class SignInForm
    extends StatelessForm<Void> {
        private static final long serialVersionUID = 1L;
        private final ValueMap properties;

        public SignInForm(String id) {
            super(id);
            this.properties = new ValueMap();
            Component[] componentArray = new Component[1];
            LoginPanel.this.username = new TextField("username", (IModel)new PropertyModel((Object)this.properties, "username"));
            componentArray[0] = LoginPanel.this.username;
            this.add(componentArray);
            Component[] componentArray2 = new Component[1];
            LoginPanel.this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)this.properties, "password"));
            componentArray2[0] = LoginPanel.this.password;
            this.add(componentArray2);
            WebMarkupContainer rememberMeRow = new WebMarkupContainer("rememberMeRow");
            this.add(new Component[]{rememberMeRow});
            rememberMeRow.add(new Component[]{new CheckBox("rememberMe", (IModel)new PropertyModel((Object)LoginPanel.this, "rememberMe"))});
            rememberMeRow.setVisible(LoginPanel.this.includeRememberMe);
        }

        public final void onSubmit() {
            if (LoginPanel.this.login(LoginPanel.this.getUsername(), LoginPanel.this.getPassword(), LoginPanel.this.getRememberMe())) {
                LoginPanel.this.onSignInSucceeded();
            }
        }
    }
}

