/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.authz;

import java.io.Serializable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.wicketstuff.shiro.annotation.AnnotationsShiroAuthorizationStrategy;
import org.wicketstuff.shiro.annotation.ShiroSecurityConstraint;

public class ShiroUnauthorizedComponentListener
implements IUnauthorizedComponentInstantiationListener {
    private final Class<? extends Page> loginPage;
    private final Class<? extends Page> unauthorizedPage;
    private AnnotationsShiroAuthorizationStrategy annotationStrategy = null;

    public ShiroUnauthorizedComponentListener(Class<? extends Page> loginPage, Class<? extends Page> unauthorizedPage, AnnotationsShiroAuthorizationStrategy s) {
        this.loginPage = loginPage;
        this.unauthorizedPage = unauthorizedPage;
        this.annotationStrategy = s;
    }

    protected Class<? extends Page> addLoginMessagesAndGetPage(ShiroSecurityConstraint constraint, Component component, Class<? extends Page> page) {
        if (constraint.loginMessage().length() > 0) {
            Session.get().info((Serializable)((Object)this.getMessage(constraint.loginMessage(), constraint, component)));
        }
        if (constraint.loginPage() != Page.class) {
            page = constraint.loginPage();
        }
        return page;
    }

    protected Class<? extends Page> addUnauthorizedMessagesAndGetPage(ShiroSecurityConstraint constraint, Component component, Class<? extends Page> page) {
        if (constraint.unauthorizedMessage().length() > 0) {
            Session.get().info((Serializable)((Object)this.getMessage(constraint.unauthorizedMessage(), constraint, component)));
        }
        if (constraint.unauthorizedPage() != Page.class) {
            page = constraint.unauthorizedPage();
        }
        return page;
    }

    public AnnotationsShiroAuthorizationStrategy getAnnotationStrategy() {
        return this.annotationStrategy;
    }

    protected String getMessage(String key, ShiroSecurityConstraint anno, Component comp) {
        return key;
    }

    public void onUnauthorizedInstantiation(Component component) {
        ShiroSecurityConstraint fail;
        Class<? extends Page> page;
        Subject subject = SecurityUtils.getSubject();
        boolean notLoggedIn = !subject.isAuthenticated();
        Class<? extends Page> clazz = page = notLoggedIn ? this.loginPage : this.unauthorizedPage;
        if (this.annotationStrategy != null && (fail = this.annotationStrategy.checkInvalidInstantiation(component.getClass())) != null) {
            if (notLoggedIn) {
                this.addLoginMessagesAndGetPage(fail, component, page);
            } else {
                this.addUnauthorizedMessagesAndGetPage(fail, component, page);
            }
        }
        if (notLoggedIn) {
            throw new RestartResponseAtInterceptPageException(page);
        }
        throw new RestartResponseException(page);
    }

    public void setAnnotationStrategy(AnnotationsShiroAuthorizationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
    }
}

