/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.reportbuilder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.IAttributes;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.TypedAttribute;

public class AttributeBuilder {
    Map<Class<? extends Enum>, Enum> attributes = new HashMap<Class<? extends Enum>, Enum>();
    Map<TypedAttribute, Serializable> typedAttributes = new HashMap<TypedAttribute, Serializable>();

    public AttributeBuilder set(Enum<?> attribute) {
        this.attributes.put(attribute.getClass(), attribute);
        return this;
    }

    public <T extends Enum<T>> T get(T defaultValue) {
        Enum ret = this.attributes.get(defaultValue.getClass());
        return (T)(ret != null ? ret : defaultValue);
    }

    public <T extends Serializable> AttributeBuilder set(TypedAttribute<T> type, T value) {
        this.typedAttributes.put(type, value);
        return this;
    }

    public <T extends Serializable> T get(TypedAttribute<T> type, T defaultValue) {
        Serializable ret = this.typedAttributes.get(type);
        return (T)(ret != null ? ret : defaultValue);
    }

    public IAttributes build() {
        return new ImmutableAttributes(this.attributes, this.typedAttributes);
    }

    private static class ImmutableAttributes
    implements IAttributes {
        private final Map<Class<? extends Enum>, Enum> attributes;
        private final Map<TypedAttribute, Serializable> typedAttributes;

        private ImmutableAttributes(Map<Class<? extends Enum>, Enum> attributes, Map<TypedAttribute, Serializable> typedAttributes) {
            HashMap<Class<? extends Enum>, Enum> attributesCopy = new HashMap<Class<? extends Enum>, Enum>();
            attributesCopy.putAll(attributes);
            HashMap<TypedAttribute, Serializable> typedAttributesCopy = new HashMap<TypedAttribute, Serializable>();
            typedAttributesCopy.putAll(typedAttributes);
            this.attributes = attributesCopy;
            this.typedAttributes = typedAttributesCopy;
        }

        @Override
        public <T extends Enum<T>> T get(T defaultValue) {
            Enum ret = this.attributes.get(defaultValue.getClass());
            return (T)(ret != null ? ret : defaultValue);
        }

        @Override
        public <T extends Serializable> T get(TypedAttribute<T> type, T defaultValue) {
            Serializable ret = this.typedAttributes.get(type);
            return (T)(ret != null ? ret : defaultValue);
        }
    }
}

