/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report.io;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.report.io.IReportKeyGenerator;

public class TimeStampKeyGenerator
implements IReportKeyGenerator {
    protected static final String DEFAULT_WITH_MILLISECONDS = "yyyy-MM-dd--hhmmss-SSS";
    private final String _pattern;

    public TimeStampKeyGenerator(String pattern) {
        this._pattern = pattern;
    }

    @Override
    public String keyOf(ISerializedObjectTree tree) {
        return TimeStampKeyGenerator.format(this._pattern, new Date());
    }

    protected static String format(String pattern, Date currentTime) {
        return new SimpleDateFormat(pattern, Locale.GERMAN).format(currentTime);
    }

    public static IReportKeyGenerator withMilliseconds() {
        return new TimeStampKeyGenerator(DEFAULT_WITH_MILLISECONDS);
    }
}

