/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report;

import java.util.ArrayList;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ImmutableTree;
import org.wicketstuff.pageserializer.common.analyze.report.Level;
import org.wicketstuff.pageserializer.common.analyze.report.filter.ITreeFilter;

public class TreeTransformations {
    static final Level TOP = new Level();

    private TreeTransformations() {
    }

    public static ISerializedObjectTree compact(ISerializedObjectTree source, ITreeFilter filter) {
        return TreeTransformations.compact(source, filter, TOP);
    }

    private static ISerializedObjectTree compact(ISerializedObjectTree source, ITreeFilter filter, Level level) {
        if (filter.accept(source, level)) {
            if (!source.children().isEmpty()) {
                boolean changed = false;
                ArrayList<ISerializedObjectTree> filteredList = new ArrayList<ISerializedObjectTree>();
                for (ISerializedObjectTree iSerializedObjectTree : source.children()) {
                    ISerializedObjectTree filtered = TreeTransformations.compact(iSerializedObjectTree, filter, level.down());
                    filteredList.add(filtered);
                    if (filtered == iSerializedObjectTree) continue;
                    changed = true;
                }
                if (changed) {
                    return new ImmutableTree(source.id(), source.type(), source.label(), source.size(), filteredList);
                }
            }
            return source;
        }
        return new ImmutableTree(source.id(), source.type(), source.label(), source.size() + source.childSize(), new ArrayList());
    }

    public static ISerializedObjectTree strip(ISerializedObjectTree source, ITreeFilter filter) {
        Level level = TOP;
        if (!filter.accept(source, level)) {
            throw new IllegalArgumentException("can not strip top level element");
        }
        return TreeTransformations.strip(source, filter, level);
    }

    private static ISerializedObjectTree strip(ISerializedObjectTree source, ITreeFilter filter, Level level) {
        boolean changed = false;
        int localSize = 0;
        ArrayList<ISerializedObjectTree> filteredList = new ArrayList<ISerializedObjectTree>();
        Level levelOneDown = level.down();
        for (ISerializedObjectTree iSerializedObjectTree : source.children()) {
            if (filter.accept(iSerializedObjectTree, levelOneDown)) {
                ISerializedObjectTree filtered = TreeTransformations.strip(iSerializedObjectTree, filter, levelOneDown);
                filteredList.add(filtered);
                if (filtered == iSerializedObjectTree) continue;
                changed = true;
                continue;
            }
            changed = true;
            localSize += iSerializedObjectTree.size();
            for (ISerializedObjectTree iSerializedObjectTree2 : iSerializedObjectTree.children()) {
                ISerializedObjectTree filtered = TreeTransformations.strip(iSerializedObjectTree2, filter, levelOneDown);
                filteredList.add(filtered);
            }
        }
        if (changed) {
            return new ImmutableTree(source.id(), source.type(), source.label(), source.size() + localSize, filteredList);
        }
        return source;
    }
}

