/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.select2;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONStringer;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.select2.AjaxSettings;
import org.wicketstuff.select2.ISelect2Theme;
import org.wicketstuff.select2.json.Json;

public final class Settings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_QUERY_PARAM = "q";
    private String language;
    private Integer minimumInputLength;
    private Integer minimumResultsForSearch;
    private Integer maximumSelectionLength;
    private Object placeholder;
    private boolean allowClear;
    private boolean multiple;
    private boolean closeOnSelect;
    private String id;
    private String matcher;
    private String tokenizer;
    private String sorter;
    private String templateSelection;
    private String templateResult;
    private String escapeMarkup;
    private String initSelection;
    private String query;
    private String width;
    private String containerCss;
    private String dropdownCss;
    private String containerCssClass;
    private String dropdownCssClass;
    private String dropdownParent;
    private AjaxSettings ajax;
    private String data;
    private boolean tags;
    private String createTag;
    private String separator;
    private String[] tokenSeparators;
    private boolean selectOnClose;
    private boolean dropdownAutoWidth;
    private ISelect2Theme theme;
    private boolean stateless = false;
    private String mountPath;
    private String queryParam = "q";

    public CharSequence toJson() {
        try {
            JSONStringer writer = new JSONStringer();
            writer.object();
            Json.writeObject(writer, "minimumInputLength", this.minimumInputLength);
            Json.writeObject(writer, "minimumResultsForSearch", this.minimumResultsForSearch);
            Json.writeObject(writer, "maximumSelectionLength", this.maximumSelectionLength);
            Json.writeObject(writer, "placeholder", this.placeholder);
            Json.writeObject(writer, "allowClear", this.allowClear);
            Json.writeObject(writer, "multiple", this.multiple);
            Json.writeObject(writer, "closeOnSelect", this.closeOnSelect);
            Json.writeFunction(writer, "id", this.id);
            Json.writeFunction(writer, "matcher", this.matcher);
            Json.writeFunction(writer, "tokenizer", this.tokenizer);
            Json.writeFunction(writer, "sorter", this.sorter);
            Json.writeFunction(writer, "templateSelection", this.templateSelection);
            Json.writeFunction(writer, "templateResult", this.templateResult);
            Json.writeFunction(writer, "escapeMarkup", this.escapeMarkup);
            Json.writeFunction(writer, "initSelection", this.initSelection);
            Json.writeFunction(writer, "query", this.query);
            Json.writeObject(writer, "width", this.width);
            Json.writeObject(writer, "theme", this.theme != null ? this.theme.name() : null);
            Json.writeFunction(writer, "containerCss", this.containerCss);
            Json.writeObject(writer, "containerCssClass", this.containerCssClass);
            Json.writeFunction(writer, "dropdownCss", this.dropdownCss);
            Json.writeObject(writer, "dropdownCssClass", this.dropdownCssClass);
            Json.writeObject(writer, "separator", this.separator);
            Json.writeObject(writer, "tokenSeparators", this.tokenSeparators);
            Json.writeObject(writer, "selectOnClose", this.selectOnClose);
            Json.writeObject(writer, "dropdownAutoWidth", this.dropdownAutoWidth);
            if (!Strings.isEmpty((CharSequence)this.dropdownParent)) {
                Json.writeFunction(writer, "dropdownParent", String.format("$('#%s')", this.dropdownParent));
            }
            if (this.ajax != null) {
                writer.key("ajax");
                this.ajax.toJson(writer);
            }
            Json.writeFunction(writer, "data", this.data);
            Json.writeObject(writer, "tags", this.tags);
            Json.writeFunction(writer, "createTag", this.createTag);
            writer.key("language").value((Object)this.getLanguage());
            writer.endObject();
            return writer.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not convert Select2 settings object to Json", e);
        }
    }

    public Integer getMinimumInputLength() {
        return this.minimumInputLength;
    }

    public Settings setMinimumInputLength(Integer minimumInputLength) {
        this.minimumInputLength = minimumInputLength;
        return this;
    }

    public Integer getMinimumResultsForSearch() {
        return this.minimumResultsForSearch;
    }

    public Settings setMinimumResultsForSearch(Integer minimumResultsForSearch) {
        this.minimumResultsForSearch = minimumResultsForSearch;
        return this;
    }

    public Object getPlaceholder() {
        return this.placeholder;
    }

    public Settings setPlaceholder(Object placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public boolean getAllowClear() {
        return this.allowClear;
    }

    public Settings setAllowClear(boolean allowClear) {
        this.allowClear = allowClear;
        if (allowClear && this.placeholder == null) {
            throw new WicketRuntimeException("Placeholder need to be specified");
        }
        return this;
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public Settings setMultiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public boolean getCloseOnSelect() {
        return this.closeOnSelect;
    }

    public Settings setCloseOnSelect(boolean closeOnSelect) {
        this.closeOnSelect = closeOnSelect;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Settings setId(String id) {
        this.id = id;
        return this;
    }

    public String getTemplateSelection() {
        return this.templateSelection;
    }

    public Settings setTemplateSelection(String templateSelection) {
        this.templateSelection = templateSelection;
        return this;
    }

    public String getTemplateResult() {
        return this.templateResult;
    }

    public Settings setTemplateResult(String templateResult) {
        this.templateResult = templateResult;
        return this;
    }

    public String getInitSelection() {
        return this.initSelection;
    }

    public Settings setInitSelection(String initSelection) {
        this.initSelection = initSelection;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public Settings setQuery(String query) {
        this.query = query;
        return this;
    }

    public AjaxSettings getAjax() {
        return this.getAjax(false);
    }

    public AjaxSettings getAjax(boolean createIfNotSet) {
        if (createIfNotSet && this.ajax == null) {
            this.ajax = new AjaxSettings();
        }
        return this.ajax;
    }

    public Settings setAjax(AjaxSettings ajax) {
        this.ajax = ajax;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public Settings setData(String data) {
        this.data = data;
        return this;
    }

    public boolean getTags() {
        return this.tags;
    }

    public Settings setTags(boolean tags) {
        this.tags = tags;
        return this;
    }

    public String getCreateTag() {
        return this.createTag;
    }

    public Settings setCreateTag(String createTag) {
        this.createTag = createTag;
        return this;
    }

    public Integer getMaximumSelectionLength() {
        return this.maximumSelectionLength;
    }

    public Settings setMaximumSelectionLength(Integer maximumSelectionLength) {
        this.maximumSelectionLength = maximumSelectionLength;
        return this;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public Settings setMatcher(String matcher) {
        this.matcher = matcher;
        return this;
    }

    public String getTokenizer() {
        return this.tokenizer;
    }

    public Settings setTokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public String getSorter() {
        return this.sorter;
    }

    public Settings setSorter(String sorter) {
        this.sorter = sorter;
        return this;
    }

    public String getEscapeMarkup() {
        return this.escapeMarkup;
    }

    public Settings setEscapeMarkup(String escapeMarkup) {
        this.escapeMarkup = escapeMarkup;
        return this;
    }

    public String getWidth() {
        return this.width;
    }

    public Settings setWidth(String width) {
        this.width = width;
        return this;
    }

    public ISelect2Theme getTheme() {
        return this.theme;
    }

    public Settings setTheme(final String theme) {
        this.theme = new ISelect2Theme(){
            private static final long serialVersionUID = 1L;

            @Override
            public void renderHead(Component varComponent, IHeaderResponse varResponse) {
            }

            @Override
            public String name() {
                return theme;
            }
        };
        return this;
    }

    public Settings setTheme(ISelect2Theme theme) {
        this.theme = theme;
        return this;
    }

    public String getContainerCss() {
        return this.containerCss;
    }

    public Settings setContainerCss(String containerCss) {
        this.containerCss = containerCss;
        return this;
    }

    public String getDropdownCss() {
        return this.dropdownCss;
    }

    public Settings setDropdownCss(String dropdownCss) {
        this.dropdownCss = dropdownCss;
        return this;
    }

    public String getContainerCssClass() {
        return this.containerCssClass;
    }

    public Settings setContainerCssClass(String containerCssClass) {
        this.containerCssClass = containerCssClass;
        return this;
    }

    public String getDropdownCssClass() {
        return this.dropdownCssClass;
    }

    public Settings setDropdownCssClass(String dropdownCssClass) {
        this.dropdownCssClass = dropdownCssClass;
        return this;
    }

    public String getDropdownParent() {
        return this.dropdownParent;
    }

    public Settings setDropdownParent(String dropdownParent) {
        this.dropdownParent = dropdownParent;
        return this;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Settings setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public String[] getTokenSeparators() {
        return this.tokenSeparators;
    }

    public Settings setTokenSeparators(String[] tokenSeparators) {
        this.tokenSeparators = tokenSeparators;
        return this;
    }

    public boolean getSelectOnClose() {
        return this.selectOnClose;
    }

    public Settings setSelectOnClose(boolean selectOnClose) {
        this.selectOnClose = selectOnClose;
        return this;
    }

    public boolean getDropdownAutoWidth() {
        return this.dropdownAutoWidth;
    }

    public Settings setDropdownAutoWidth(boolean dropdownAutoWidth) {
        this.dropdownAutoWidth = dropdownAutoWidth;
        return this;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public Settings setStateless(boolean stateless) {
        this.stateless = stateless;
        return this;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public Settings setMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    public String getQueryParam() {
        return this.queryParam;
    }

    public Settings setQueryParam(String queryParam) {
        this.queryParam = queryParam;
        return this;
    }

    public String getLanguage() {
        return Strings.defaultIfEmpty((String)this.language, (String)Session.get().getLocale().getLanguage());
    }

    public Settings setLanguage(String language) {
        this.language = language;
        return this;
    }

    public static class Widths {
        public static String OFF = "off";
        public static String COPY = "copy";
        public static String RESOLVE = "resolve";
        public static String ELEMENT = "element";
    }
}

