/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.utils.mounting;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.rest.annotations.ResourcePath;

public class PackageScanner {
    private static final Logger log = LoggerFactory.getLogger(PackageScanner.class);

    public static void scanPackage(String ... packageNames) {
        Args.notNull((Object)packageNames, (String)"packageNames");
        PackageScanner.scanPackage(WebApplication.get(), packageNames);
    }

    public static void scanPackage(WebApplication application, String ... packageNames) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)packageNames, (String)"packageNames");
        for (String packageName : packageNames) {
            PackageScanner.scanPackage(application, packageName);
        }
    }

    public static void scanPackage(WebApplication application, String packageName) {
        Args.notNull((Object)application, (String)"application");
        Args.notNull((Object)packageName, (String)"packageName");
        try {
            Class<?>[] packageClasses;
            for (Class<?> clazz : packageClasses = PackageScanner.getClasses(packageName)) {
                PackageScanner.mountAnnotatedResource(application, clazz);
            }
        }
        catch (Exception exception) {
            throw new WicketRuntimeException((Throwable)exception);
        }
    }

    private static void mountAnnotatedResource(WebApplication application, Class<?> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ResourcePath mountAnnotation = clazz.getAnnotation(ResourcePath.class);
        if (mountAnnotation == null || !IResource.class.isAssignableFrom(clazz)) {
            return;
        }
        String path = mountAnnotation.value();
        final IResource resourceInstance = (IResource)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (Injector.get() != null) {
            Injector.get().inject((Object)resourceInstance);
        }
        application.mountResource(path, new ResourceReference(clazz.getSimpleName()){
            private static final long serialVersionUID = 1L;

            public IResource getResource() {
                return resourceInstance;
            }
        });
        log.info("Resource '" + clazz.getSimpleName() + "' has been mounted to path '" + path + "'");
    }

    private static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException, URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Args.notNull((Object)classLoader, (String)"classLoader");
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<JarFile> jars = new ArrayList<JarFile>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String protocol = resource.getProtocol();
            if ("jar".equals(protocol) || "wsjar".equals(protocol)) {
                String jarFileName = URLDecoder.decode(resource.getFile(), "UTF-8");
                jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
                jars.add(new JarFile(jarFileName));
                continue;
            }
            dirs.add(new File(resource.toURI()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(PackageScanner.findClasses(directory, packageName));
        }
        for (JarFile jarFile : jars) {
            classes.addAll(PackageScanner.findClasses(jarFile, path));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(PackageScanner.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    private static Collection<? extends Class<?>> findClasses(JarFile jarFile, String path) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            int classExtensionIndex = entryName.indexOf(".class");
            if (!entryName.startsWith(path) || classExtensionIndex < 0) continue;
            entryName = entryName.substring(0, classExtensionIndex);
            entryName = entryName.replace('/', '.');
            classes.add(Class.forName(entryName));
        }
        return classes;
    }
}

