/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource.urlsegments;

import java.util.regex.Matcher;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;
import org.wicketstuff.rest.resource.urlsegments.visitor.ISegmentVisitor;

public class ParamSegment
extends AbstractURLSegment {
    private static final long serialVersionUID = 1L;
    private final String paramName = this.loadParamName();

    ParamSegment(String text) {
        super(text);
    }

    private String loadParamName() {
        String segmentContent = this.toString();
        Matcher matcher = MetaPattern.VARIABLE_NAME.matcher((CharSequence)segmentContent);
        matcher.find();
        return matcher.group();
    }

    @Override
    protected MetaPattern loadMetaPattern() {
        String segmentContent = this.toString();
        int semicolonIndex = segmentContent.indexOf(58);
        if (semicolonIndex < 0) {
            return MetaPattern.ANYTHING_NON_EMPTY;
        }
        String regExp = segmentContent.substring(semicolonIndex + 1, segmentContent.length() - 1);
        Matcher matcher = REGEXP_BODY.matcher((CharSequence)regExp);
        matcher.matches();
        String group = matcher.group();
        return new MetaPattern(group);
    }

    public String getParamName() {
        return this.paramName;
    }

    @Override
    public void accept(ISegmentVisitor visitor) {
        visitor.visit(this);
    }
}

