/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.util.collections.MultiMap;
import org.wicketstuff.rest.annotations.AuthorizeInvocation;
import org.wicketstuff.rest.annotations.MethodMapping;
import org.wicketstuff.rest.contenthandling.mimetypes.IMimeTypeResolver;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;
import org.wicketstuff.rest.utils.collection.CollectionUtils;
import org.wicketstuff.rest.utils.reflection.MethodParameter;
import org.wicketstuff.restutils.http.HttpMethod;

public class MethodMappingInfo
implements IMimeTypeResolver {
    private final HttpMethod httpMethod;
    private final List<AbstractURLSegment> segments;
    private final Roles roles;
    private final Method method;
    private final String inputFormat;
    private final String outputFormat;
    private final List<MethodParameter<?>> methodParameters;
    private final Map<Class<? extends Annotation>, List<MethodParameter<?>>> annotatedMethodParameters;

    public MethodMappingInfo(MethodMapping methodMapped, Method method) {
        this.httpMethod = methodMapped.httpMethod();
        this.method = method;
        this.segments = Collections.unmodifiableList(this.loadSegments(methodMapped.value()));
        this.roles = this.loadRoles();
        this.inputFormat = methodMapped.consumes();
        this.outputFormat = methodMapped.produces();
        this.methodParameters = this.loadMethodParameters(method);
        this.annotatedMethodParameters = this.loadAnnotatedMethodParameters();
    }

    private List<MethodParameter<?>> loadMethodParameters(Method method) {
        Class<?>[] paramsTypes = method.getParameterTypes();
        ArrayList methodParameters = new ArrayList();
        for (int i = 0; i < paramsTypes.length; ++i) {
            methodParameters.add(new MethodParameter(paramsTypes[i], this, i));
        }
        return Collections.unmodifiableList(methodParameters);
    }

    private Map<Class<? extends Annotation>, List<MethodParameter<?>>> loadAnnotatedMethodParameters() {
        MultiMap result = new MultiMap();
        for (MethodParameter<?> methodParameter : this.methodParameters) {
            Annotation annotationParam = methodParameter.getAnnotationParam();
            if (annotationParam == null) continue;
            result.addValue(annotationParam.getClass(), methodParameter);
        }
        return CollectionUtils.makeListMapImmutable(result);
    }

    private List<AbstractURLSegment> loadSegments(String urlPath) {
        String[] segArray = urlPath.split("/");
        ArrayList<AbstractURLSegment> segments = new ArrayList<AbstractURLSegment>();
        for (int i = 0; i < segArray.length; ++i) {
            String segment = segArray[i];
            if (segment.isEmpty()) continue;
            AbstractURLSegment segmentValue = AbstractURLSegment.newSegment(segment);
            segments.add(segmentValue);
        }
        return segments;
    }

    private Roles loadRoles() {
        AuthorizeInvocation authorizeInvocation = this.method.getAnnotation(AuthorizeInvocation.class);
        Roles roles = new Roles();
        if (authorizeInvocation != null) {
            roles = new Roles(authorizeInvocation.value());
        }
        return roles;
    }

    public List<AbstractURLSegment> getSegments() {
        return this.segments;
    }

    public int getSegmentsCount() {
        return this.segments.size();
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Method getMethod() {
        return this.method;
    }

    public Roles getRoles() {
        return this.roles;
    }

    @Override
    public String getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public List<MethodParameter<?>> getMethodParameters() {
        return this.methodParameters;
    }

    public Map<Class<? extends Annotation>, List<MethodParameter<?>>> getAnnotatedMethodParameters() {
        return this.annotatedMethodParameters;
    }
}

