/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.collections.MultiMap;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IErrorMessageSource;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.Validatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.rest.annotations.AuthorizeInvocation;
import org.wicketstuff.rest.annotations.MethodMapping;
import org.wicketstuff.rest.contenthandling.IWebSerialDeserial;
import org.wicketstuff.rest.resource.MethodMappingInfo;
import org.wicketstuff.rest.resource.RestResourceLocaleLocator;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;
import org.wicketstuff.rest.resource.urlsegments.visitor.ScoreMethodAndExtractPathVars;
import org.wicketstuff.rest.utils.collection.CollectionUtils;
import org.wicketstuff.rest.utils.reflection.MethodParameter;
import org.wicketstuff.rest.utils.reflection.ReflectionUtils;
import org.wicketstuff.rest.utils.wicket.MethodParameterContext;
import org.wicketstuff.rest.utils.wicket.bundle.DefaultBundleResolver;
import org.wicketstuff.restutils.http.HttpMethod;
import org.wicketstuff.restutils.http.HttpUtils;
import org.wicketstuff.restutils.wicket.AttributesWrapper;

public abstract class AbstractRestResource<T extends IWebSerialDeserial>
implements IResource {
    private static final long serialVersionUID = 1L;
    public static final String NO_SUITABLE_METHOD_FOUND = "No suitable method found.";
    public static final String USER_IS_NOT_ALLOWED = "User is not allowed to use this resource.";
    private static final Logger log = LoggerFactory.getLogger(AbstractRestResource.class);
    private final Map<String, List<MethodMappingInfo>> mappedMethods;
    private final Map<Method, MethodMappingInfo> mappedMethodsInfo;
    private final Map<String, IValidator<?>> declaredValidators = new HashMap();
    private final T webSerialDeserial;
    private final IRoleCheckingStrategy roleCheckingStrategy;
    private final IErrorMessageSource bundleResolver;

    public AbstractRestResource(T serialDeserial) {
        this(serialDeserial, null);
    }

    public AbstractRestResource(T serialDeserial, IRoleCheckingStrategy roleCheckingStrategy) {
        Args.notNull(serialDeserial, (String)"serialDeserial");
        this.onInitialize(serialDeserial);
        this.webSerialDeserial = serialDeserial;
        this.roleCheckingStrategy = roleCheckingStrategy;
        this.mappedMethods = this.loadAnnotatedMethods();
        this.mappedMethodsInfo = this.loadAnnotatedMethodsInfo();
        this.bundleResolver = new DefaultBundleResolver(this.loadBundleClasses());
    }

    private List<Class<?>> loadBundleClasses() {
        Collection<IValidator<?>> validators = this.declaredValidators.values();
        List<Class<?>> validatorsClasses = ReflectionUtils.getElementsClasses(validators);
        validatorsClasses.add(this.getClass());
        return validatorsClasses;
    }

    public final void respond(IResource.Attributes attributes) {
        AttributesWrapper attributesWrapper = new AttributesWrapper(attributes);
        WebResponse response = attributesWrapper.getWebResponse();
        HttpMethod httpMethod = attributesWrapper.getHttpMethod();
        ScoreMethodAndExtractPathVars mappedMethod = this.selectMostSuitedMethod(attributesWrapper);
        if (mappedMethod != null) {
            this.handleMethodExecution(attributesWrapper, mappedMethod);
        } else {
            this.noSuitableMethodFound(response, httpMethod);
        }
    }

    private void handleMethodExecution(AttributesWrapper attributesWrapper, ScoreMethodAndExtractPathVars mappedMethod) {
        WebResponse response = attributesWrapper.getWebResponse();
        MethodMappingInfo methodInfo = mappedMethod.getMethodInfo();
        IResource.Attributes attributes = attributesWrapper.getOriginalAttributes();
        String outputFormat = methodInfo.getOutputFormat();
        response.setContentType(outputFormat);
        if (!this.isUserAuthorized(methodInfo.getRoles())) {
            this.unauthorizedMethodAccess(response, methodInfo);
            return;
        }
        List<?> parametersValues = null;
        try {
            parametersValues = this.extractMethodParameters(mappedMethod, attributesWrapper);
        }
        catch (RuntimeException e) {
            this.setResponseStatusCode(this.resolveExceptionStatusCode(e, 400));
            this.handleException(AbstractRestResource.getCurrentWebResponse(), e);
            return;
        }
        List<IValidationError> validationErrors = this.validateMethodParameters(methodInfo, parametersValues);
        if (validationErrors.size() > 0) {
            IValidationError error = validationErrors.get(0);
            this.handleValidationError(response, outputFormat, error);
            response.setStatus(this.resolveValidationErrorStatusCode(error, 400));
            return;
        }
        this.onBeforeMethodInvoked(methodInfo, attributes);
        Object result = this.invokeMappedMethod(methodInfo.getMethod(), parametersValues, response);
        this.onAfterMethodInvoked(methodInfo, attributes, result);
        if (result != null) {
            this.objectToResponse(result, response, outputFormat);
        }
    }

    private boolean isUserAuthorized(Roles roles) {
        if (roles.isEmpty()) {
            return true;
        }
        return this.roleCheckingStrategy.hasAnyRole(roles);
    }

    protected void unauthorizedMethodAccess(WebResponse response, MethodMappingInfo methodInfo) {
        response.write((CharSequence)USER_IS_NOT_ALLOWED);
        response.setStatus(401);
    }

    public void noSuitableMethodFound(WebResponse response, HttpMethod httpMethod) {
        response.setStatus(400);
        response.write((CharSequence)("No suitable method found. URL '" + AbstractRestResource.extractUrlFromRequest() + "' and HTTP method " + httpMethod));
    }

    private List<IValidationError> validateMethodParameters(MethodMappingInfo mappedMethod, List<?> parametersValues) {
        List<MethodParameter<?>> methodParameters = mappedMethod.getMethodParameters();
        ArrayList<IValidationError> errors = new ArrayList<IValidationError>();
        for (MethodParameter<?> methodParameter : methodParameters) {
            String validatorKey = methodParameter.getValdatorKey();
            if (Strings.isEmpty((CharSequence)validatorKey)) continue;
            int i = methodParameters.indexOf(methodParameter);
            Object parameterValue = parametersValues.get(i);
            this.validateMethodParameter(errors, validatorKey, parameterValue);
        }
        return errors;
    }

    private <E> void validateMethodParameter(List<IValidationError> errors, String validatorKey, E parameterValue) {
        IValidator<E> validator = this.getValidator(validatorKey, parameterValue);
        Validatable validatable = new Validatable(parameterValue);
        if (validator != null) {
            validator.validate((IValidatable)validatable);
            errors.addAll(validatable.getErrors());
        } else {
            log.debug("No validator found for key '" + validatorKey + "'");
        }
    }

    protected void onBeforeMethodInvoked(MethodMappingInfo mappedMethod, IResource.Attributes attributes) {
    }

    protected void onAfterMethodInvoked(MethodMappingInfo mappedMethod, IResource.Attributes attributes, Object result) {
    }

    public void objectToResponse(Object result, WebResponse response, String mimeType) {
        try {
            this.webSerialDeserial.objectToResponse(result, response, mimeType);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing object to response.", e);
        }
    }

    private ScoreMethodAndExtractPathVars selectMostSuitedMethod(AttributesWrapper attributesWrapper) {
        PageParameters pageParameters = attributesWrapper.getPageParameters();
        List<MethodMappingInfo> mappedMethodsCandidates = this.mappedMethods.get(pageParameters.getIndexedCount() + "_" + attributesWrapper.getHttpMethod());
        MultiMap scoredMethods = new MultiMap();
        if (mappedMethodsCandidates == null || mappedMethodsCandidates.size() == 0) {
            return null;
        }
        int highestScore = 0;
        for (MethodMappingInfo mappedMethod : mappedMethodsCandidates) {
            int methodScore;
            ScoreMethodAndExtractPathVars scoredMethod = new ScoreMethodAndExtractPathVars(mappedMethod, pageParameters);
            for (AbstractURLSegment segment : mappedMethod.getSegments()) {
                segment.accept(scoredMethod);
                if (scoredMethod.isSegmentValid()) continue;
                break;
            }
            if ((methodScore = scoredMethod.isSegmentValid() ? scoredMethod.getScore() : -1) < highestScore) continue;
            highestScore = methodScore;
            scoredMethods.addValue((Object)highestScore, (Object)scoredMethod);
        }
        List methodsWithScore = (List)scoredMethods.get((Object)highestScore);
        if (methodsWithScore != null && methodsWithScore.size() > 1) {
            this.throwAmbiguousMethodsException((List)scoredMethods.get((Object)highestScore));
        }
        return (ScoreMethodAndExtractPathVars)scoredMethods.getFirstValue((Object)highestScore);
    }

    private void throwAmbiguousMethodsException(List<ScoreMethodAndExtractPathVars> methods) {
        WebRequest request = AbstractRestResource.getCurrentWebRequest();
        StringBuilder methodsNames = new StringBuilder();
        for (ScoreMethodAndExtractPathVars method : methods) {
            if (methodsNames.length() != 0) {
                methodsNames.append(", ");
            }
            MethodMappingInfo urlMappingInfo = method.getMethodInfo();
            methodsNames.append(urlMappingInfo.getMethod().getReturnType().getSimpleName());
            methodsNames.append(" ");
            methodsNames.append(urlMappingInfo.getMethod().getDeclaringClass().getSimpleName());
            methodsNames.append(".");
            methodsNames.append(urlMappingInfo.getMethod().getName());
        }
        throw new WicketRuntimeException("Ambiguous methods mapped for the current request: URL '" + request.getClientUrl() + "', HTTP method " + HttpUtils.getHttpMethod((WebRequest)request) + ". Mapped methods: " + methodsNames);
    }

    protected void onInitialize(T objSerialDeserial) {
    }

    private Map<String, List<MethodMappingInfo>> loadAnnotatedMethods() {
        Method[] methods = this.getClass().getDeclaredMethods();
        MultiMap mappedMethods = new MultiMap();
        boolean isUsingAuthAnnot = false;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            MethodMapping methodMapped = method.getAnnotation(MethodMapping.class);
            AuthorizeInvocation authorizeInvocation = method.getAnnotation(AuthorizeInvocation.class);
            boolean bl = isUsingAuthAnnot = isUsingAuthAnnot || authorizeInvocation != null;
            if (methodMapped == null || method.isBridge()) continue;
            HttpMethod httpMethod = methodMapped.httpMethod();
            MethodMappingInfo methodMappingInfo = new MethodMappingInfo(methodMapped, method);
            if (!this.webSerialDeserial.isMimeTypeSupported(methodMappingInfo.getInputFormat()) || !this.webSerialDeserial.isMimeTypeSupported(methodMappingInfo.getOutputFormat())) {
                throw new WicketRuntimeException("Mapped methods use a MIME type not supported by obj serializer/deserializer!");
            }
            String key = methodMappingInfo.getSegmentsCount() + "_" + httpMethod.getMethod();
            mappedMethods.addValue((Object)key, (Object)methodMappingInfo);
            log.debug("Added mapped method: {} with key: {}", (Object)method, (Object)key);
        }
        if (isUsingAuthAnnot && this.roleCheckingStrategy == null) {
            throw new WicketRuntimeException("Annotation AuthorizeInvocation is used but no role-checking strategy has been set for the controller!");
        }
        return CollectionUtils.makeListMapImmutable(mappedMethods);
    }

    private Map<Method, MethodMappingInfo> loadAnnotatedMethodsInfo() {
        HashMap<Method, MethodMappingInfo> methodsInfo = new HashMap<Method, MethodMappingInfo>();
        for (List<MethodMappingInfo> methodInfoList : this.mappedMethods.values()) {
            for (MethodMappingInfo methodMappedInfo : methodInfoList) {
                methodsInfo.put(methodMappedInfo.getMethod(), methodMappedInfo);
            }
        }
        return Collections.unmodifiableMap(methodsInfo);
    }

    private List<?> extractMethodParameters(ScoreMethodAndExtractPathVars mappedMethod, AttributesWrapper attributesWrapper) {
        ArrayList<Object> parametersValues = new ArrayList<Object>();
        Map<String, String> pathParameters = mappedMethod.getPathVariables();
        MethodParameterContext parameterContext = new MethodParameterContext(attributesWrapper, pathParameters, (IWebSerialDeserial)this.webSerialDeserial);
        for (MethodParameter<?> methodParameter : mappedMethod.getMethodInfo().getMethodParameters()) {
            Object paramValue = methodParameter.extractParameterValue(parameterContext);
            if (paramValue == null && methodParameter.isRequired()) {
                String exMsg = String.format("No valid value could be found the given method parameter: method %s, parameter index %d", mappedMethod.getMethodInfo().getMethod().getName(), methodParameter.getParamIndex());
                log.debug(exMsg);
                throw new WicketRuntimeException(exMsg);
            }
            parametersValues.add(paramValue);
        }
        return parametersValues;
    }

    private Object invokeMappedMethod(Method method, List<?> parametersValues, WebResponse response) {
        try {
            return method.invoke((Object)this, parametersValues.toArray());
        }
        catch (Exception exception) {
            response.setStatus(this.resolveExceptionStatusCode(exception, 500));
            this.handleException(response, exception);
            log.debug("Error invoking method '" + method.getName() + "'");
            return null;
        }
    }

    protected void handleException(WebResponse response, Exception exception) {
        String exceptionMsg = "General server error.";
        response.write((CharSequence)exceptionMsg);
        log.error(exceptionMsg, (Throwable)exception);
    }

    protected int resolveExceptionStatusCode(Exception e, int defaultStatusCode) {
        return defaultStatusCode;
    }

    protected int resolveValidationErrorStatusCode(IValidationError error, int defaultStatusCode) {
        return defaultStatusCode;
    }

    protected void handleValidationError(WebResponse response, String outputFormat, IValidationError error) {
        Serializable message = error.getErrorMessage(this.bundleResolver);
        this.webSerialDeserial.objectToResponse(message, response, outputFormat);
    }

    public static Url extractUrlFromRequest() {
        return RequestCycle.get().getRequest().getClientUrl();
    }

    public <E> E requestToObject(WebRequest request, Class<E> argClass, String mimeType) {
        try {
            return this.webSerialDeserial.requestToObject(request, argClass, mimeType);
        }
        catch (Exception e) {
            log.debug("Error deserializing object from request", (Throwable)e);
            return null;
        }
    }

    public static final WebRequest getCurrentWebRequest() {
        return (WebRequest)RequestCycle.get().getRequest();
    }

    public static Object toObject(Class<?> clazz, String value) throws RuntimeException {
        if (value == null) {
            return null;
        }
        IConverter converter = Application.get().getConverterLocator().getConverter(clazz);
        if (converter == null) {
            String exMsg = String.format("Could not find a suitable converter for value '%s' of type '%s'", value, clazz.getName());
            log.debug(exMsg);
            throw new WicketRuntimeException(exMsg);
        }
        try {
            return converter.convertToObject(value, RestResourceLocaleLocator.get().getLocale());
        }
        catch (ConversionException exception) {
            String exMsg = String.format("Value '%s' can not be converted to type '%s'", value, clazz.getName());
            log.debug(exMsg, (Throwable)exception);
            throw new WicketRuntimeException(exMsg, (Throwable)exception);
        }
    }

    public static final WebResponse getCurrentWebResponse() {
        return (WebResponse)RequestCycle.get().getResponse();
    }

    protected final void setResponseStatusCode(int statusCode) {
        try {
            AbstractRestResource.getCurrentWebResponse().setStatus(statusCode);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find a suitable WebResponse object for the current ThreadContext.", e);
        }
    }

    protected Map<String, List<MethodMappingInfo>> getMappedMethods() {
        return this.mappedMethods;
    }

    protected final void registerValidator(String key, IValidator<?> validator) {
        this.declaredValidators.put(key, validator);
    }

    protected final void unregisterValidator(String key) {
        this.declaredValidators.remove(key);
    }

    protected final <E> IValidator<E> getValidator(String key, E validatorType) {
        return this.declaredValidators.get(key);
    }

    public Map<Method, MethodMappingInfo> getMappedMethodsInfo() {
        return this.mappedMethodsInfo;
    }

    public MethodMappingInfo getMethodInfo(Method method) {
        return this.mappedMethodsInfo.get(method);
    }
}

