/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.progressbar.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.progressbar.Progression;
import org.wicketstuff.progressbar.spring.ITaskService;
import org.wicketstuff.progressbar.spring.Task;

public class TaskService
implements ITaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskService.class);
    private final Executor executor;
    private Map<Long, Task> tasks = new HashMap<Long, Task>();
    private long nextTaskId = 0L;

    public TaskService(Executor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized Long schedule(Task task) {
        Long taskId = this.nextTaskId();
        LOGGER.debug("Scheduling task with ID: " + taskId);
        this.tasks.put(taskId, task);
        return taskId;
    }

    @Override
    public void start(Long taskId) {
        Task task = this.getTask(taskId);
        if (task != null) {
            LOGGER.debug("Starting task with ID: " + taskId);
            this.start(task);
        } else {
            LOGGER.warn("Task ID " + taskId + " not found");
        }
    }

    @Override
    public void cancel(Long taskId) {
        Task task = this.getTask(taskId);
        if (task != null) {
            task.cancel();
        }
    }

    private void start(Task task) {
        this.executor.execute(task.getRunnable());
    }

    Task getTask(Long taskId) {
        return this.tasks.get(taskId);
    }

    private synchronized long nextTaskId() {
        return this.nextTaskId++;
    }

    @Override
    public Long scheduleAndStart(Task task) {
        Long taskId = this.schedule(task);
        this.start(task);
        return taskId;
    }

    @Override
    public void finish(Long taskId) {
        this.tasks.remove(taskId);
    }

    @Override
    public Progression getProgression(Long taskId) {
        Task task = this.getTask(taskId);
        return task == null || task.isDone() ? new Progression(100) : new Progression(task.getProgress());
    }

    @Override
    public List<Task.Message> getMessages(Long taskId) {
        Task task = this.getTask(taskId);
        return task.getMessages();
    }
}

