/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.poi.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public class XlsStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    private transient Workbook wb;
    private transient InputStream inputStream;

    public XlsStream(Workbook wb) {
        this.wb = wb;
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        if (this.inputStream == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.wb.write((OutputStream)out);
                out.close();
                this.inputStream = new ByteArrayInputStream(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.inputStream;
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    public String getContentType() {
        return "application/vnd.ms-excel";
    }

    public Time lastModifiedTime() {
        return Time.now();
    }
}

