/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.poi.excel;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.wicketstuff.poi.excel.CellExporter;

public class GeneralPurposeExporter
implements CellExporter {
    @Override
    public void exportCell(XmlTag tag, XmlPullParser parser, Cell cell, Component gridComponent) throws ParseException {
        XmlTag firstMostNestedTag = tag;
        while (!(tag = parser.nextTag()).getName().equals("td") && (tag.isOpen() || tag.isOpenClose())) {
            firstMostNestedTag = tag;
        }
        CharSequence possibleComponentReference = firstMostNestedTag.getAttribute("component_path");
        if (possibleComponentReference != null) {
            Link link;
            Component firstMostNestedComponent = gridComponent.getPage().get(possibleComponentReference.toString());
            if (firstMostNestedComponent.getClass().getName().contains("ResourceReferenceAutolink")) {
                cell.setCellValue("");
                return;
            }
            if (firstMostNestedComponent instanceof Link && (firstMostNestedComponent = this.getLinkInnerComponent(link = (Link)firstMostNestedComponent)) == null) {
                cell.setCellValue("");
                return;
            }
            Object modelValue = firstMostNestedComponent.getDefaultModelObject();
            if (modelValue != null) {
                if (modelValue instanceof Number) {
                    this.handleNumber(cell, (Number)modelValue);
                } else if (modelValue instanceof CharSequence) {
                    cell.setCellValue(modelValue.toString());
                } else if (modelValue instanceof CharSequence) {
                    cell.setCellValue(modelValue.toString());
                } else if (modelValue instanceof Boolean) {
                    cell.setCellValue(((Boolean)modelValue).booleanValue());
                } else if (modelValue instanceof Calendar) {
                    this.handleCalendar(cell, (Calendar)modelValue);
                } else if (modelValue instanceof Date) {
                    this.handleDate(cell, (Date)modelValue);
                } else {
                    cell.setCellValue(modelValue.toString());
                }
            }
        } else {
            String value = parser.getInput(firstMostNestedTag.getPos() + firstMostNestedTag.getLength(), tag.getPos()).toString();
            cell.setCellValue(value);
        }
    }

    protected void handleNumber(Cell cell, Number number) {
        cell.setCellValue(number.doubleValue());
    }

    protected void handleCalendar(Cell cell, Calendar calendar) {
        cell.setCellValue(calendar);
    }

    protected void handleDate(Cell cell, Date date) {
        cell.setCellValue(date);
    }

    protected Component getLinkInnerComponent(Link<?> link) {
        return (Component)link.iterator().next();
    }
}

