/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.poi.datatable.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.AbstractDataExporter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class AbstractExcelDataExporter
extends AbstractDataExporter {
    public AbstractExcelDataExporter(IModel<String> dataFormatNameModel, String contentType, String fileNameExtension) {
        super(dataFormatNameModel, contentType, fileNameExtension);
    }

    protected abstract Workbook createWorkbook();

    public <T> void exportData(IDataProvider<T> dataProvider, List<IExportableColumn<T, ?>> columns, OutputStream outputStream) throws IOException {
        Workbook workbook = this.createWorkbook();
        Sheet sheet = workbook.createSheet();
        int rowNumber = 0;
        Row row = sheet.createRow(rowNumber);
        ++rowNumber;
        int columnNumber = 0;
        for (IExportableColumn<T, ?> column : columns) {
            Cell cell = row.createCell(columnNumber);
            IModel headerModel = column.getDisplayModel();
            if (headerModel != null) {
                String header = (String)headerModel.getObject();
                this.populateHeaderCell(cell, header, columnNumber, column, workbook);
            } else {
                this.populateHeaderCell(cell, null, columnNumber, column, workbook);
            }
            ++columnNumber;
        }
        Iterator it = dataProvider.iterator(0L, dataProvider.size());
        while (it.hasNext()) {
            Object rowObject = it.next();
            IModel rowModel = dataProvider.model(rowObject);
            row = sheet.createRow(rowNumber);
            ++rowNumber;
            columnNumber = 0;
            for (IExportableColumn<T, ?> column : columns) {
                Cell cell = row.createCell(columnNumber);
                this.populateCell(cell, rowModel, column, rowNumber - 1, columnNumber, workbook);
                ++columnNumber;
            }
        }
        workbook.write(outputStream);
    }

    protected void populateHeaderCell(Cell cell, String value, int columnIndex, IExportableColumn<?, ?> column, Workbook workbook) {
        if (value != null) {
            cell.setCellValue(value);
        }
    }

    protected <T> void populateCell(Cell cell, IModel<T> rowModel, IExportableColumn<T, ?> column, int rowIndex, int columnIndex, Workbook workbook) {
        Object cellValue;
        IModel cellModel = column.getDataModel(rowModel);
        if (cellModel != null && (cellValue = cellModel.getObject()) != null) {
            if (cellValue instanceof Boolean) {
                cell.setCellValue(((Boolean)cellValue).booleanValue());
            } else if (cellValue instanceof Number) {
                cell.setCellValue(((Number)cellValue).doubleValue());
            } else if (cellValue instanceof Date) {
                cell.setCellValue((Date)cellValue);
            } else {
                Class<?> c = cellValue.getClass();
                IConverter converter = Application.get().getConverterLocator().getConverter(c);
                String s = converter == null ? cellValue.toString() : converter.convertToString(cellValue, Session.get().getLocale());
                cell.setCellValue(s);
            }
        }
    }
}

