/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.objectautocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteBuilder;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteCancelListener;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteSelectionChangeListener;
import org.wicketstuff.objectautocomplete.ObjectReadOnlyRenderer;

public class ObjectAutoCompleteField<O, I extends Serializable>
extends FormComponentPanel<I>
implements ObjectAutoCompleteCancelListener {
    private static final long serialVersionUID = 1L;
    private static final Set<String> ALLOWED_SPAN_ATTRIBUTES = new HashSet<String>(Arrays.asList("wicket:id", "id", "class", "lang", "dir", "title", "style", "align", "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmousemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup"));
    private final List<ObjectAutoCompleteSelectionChangeListener<I>> selectionChangeListeners = new ArrayList<ObjectAutoCompleteSelectionChangeListener<I>>();
    private I selectedObjectId = (Serializable)this.getModelObject();
    private I backupObjectId;
    private String backupText;
    private TextField<String> searchTextField;
    private HiddenField<I> objectField;
    private final boolean clearInputOnSelection;

    ObjectAutoCompleteField(String pId, IModel<I> pModel, ObjectAutoCompleteBuilder<O, I> pBuilder) {
        super(pId, pModel);
        this.setOutputMarkupId(true);
        pBuilder.cancelListener(this);
        for (ObjectAutoCompleteSelectionChangeListener listener : pBuilder.selectionChangeListener) {
            this.registerForUpdateOnSelectionChange(listener);
        }
        Model searchTextModel = new Model();
        this.addSearchTextField((Model<String>)searchTextModel, pBuilder);
        this.addReadOnlyPanel((Model<String>)searchTextModel, pBuilder);
        this.clearInputOnSelection = pBuilder.clearInputOnSelection;
    }

    public void registerForUpdateOnSelectionChange(ObjectAutoCompleteSelectionChangeListener<I> pListener) {
        this.selectionChangeListeners.add(pListener);
    }

    private void addSearchTextField(Model<String> pSearchTextModel, ObjectAutoCompleteBuilder<O, I> pBuilder) {
        this.searchTextField = new TextField<String>("search", pSearchTextModel){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return ObjectAutoCompleteField.this.isSearchMode();
            }
        };
        this.searchTextField.setOutputMarkupId(true);
        this.searchTextField.add(new Behavior[]{AttributeModifier.append((String)"autocomplete", (Serializable)((Object)"off"))});
        this.objectField = new HiddenField("hiddenId", (IModel)new PropertyModel((Object)this, "selectedObjectId"));
        this.objectField.setOutputMarkupId(true);
        if (pBuilder.idType != null) {
            this.objectField.setType(pBuilder.idType);
        }
        this.add(new Component[]{this.objectField});
        this.searchTextField.add(new Behavior[]{pBuilder.buildBehavior((Component)this.objectField), new ObjectUpdateBehavior()});
        this.add(new Component[]{this.searchTextField});
    }

    protected IModel<I> initModel() {
        IWrapModel iwModel;
        IModel model = super.initModel();
        if (model instanceof IWrapModel && (iwModel = (IWrapModel)model).getWrappedModel() instanceof CompoundPropertyModel) {
            CompoundPropertyModel cpModel = (CompoundPropertyModel)iwModel.getWrappedModel();
            this.objectField.setModel((IModel)new PropertyModel((Object)cpModel, this.getId()));
        }
        return model;
    }

    private void addReadOnlyPanel(Model<String> pSearchTextModel, ObjectAutoCompleteBuilder<O, I> pBuilder) {
        WebMarkupContainer wac = new WebMarkupContainer("readOnlyPanel"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return !ObjectAutoCompleteField.this.isSearchMode();
            }
        };
        wac.setOutputMarkupId(true);
        ObjectReadOnlyRenderer roRenderer = pBuilder.readOnlyObjectRenderer;
        Object objectReadOnlyComponent = roRenderer != null ? roRenderer.getObjectRenderer("selectedValue", new PropertyModel((Object)this, "selectedObjectId"), (IModel<String>)pSearchTextModel) : new Label("selectedValue", pSearchTextModel);
        objectReadOnlyComponent.setOutputMarkupId(true);
        AjaxFallbackLink<Void> deleteLink = new AjaxFallbackLink<Void>("searchLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ObjectAutoCompleteField.this.changeToSearchMode(target);
            }
        };
        Component linkImage = new WebComponent("searchLinkImage").setVisible(false);
        if (pBuilder.imageResource != null || pBuilder.imageResourceReference != null) {
            linkImage = pBuilder.imageResource != null ? new Image("searchLinkImage", pBuilder.imageResource) : new Image("searchLinkImage", pBuilder.imageResourceReference);
            deleteLink.add(new Component[]{new Label("searchLinkPanel").setVisible(false)});
        } else if (pBuilder.searchLinkContent != null) {
            deleteLink.add(new Component[]{pBuilder.searchLinkContent});
        } else if (!pBuilder.unchangeable) {
            deleteLink.add(new Component[]{new Label("searchLinkPanel", pBuilder.searchLinkText)});
        }
        deleteLink.add(new Component[]{linkImage});
        if (pBuilder.searchOnClick) {
            deleteLink.setVisible(false);
            objectReadOnlyComponent.add(new Behavior[]{new AjaxEventBehavior("onclick"){
                private static final long serialVersionUID = 1L;

                protected void onEvent(AjaxRequestTarget target) {
                    ObjectAutoCompleteField.this.changeToSearchMode(target);
                }
            }});
        }
        wac.add(new Component[]{objectReadOnlyComponent});
        wac.add(new Component[]{deleteLink});
        this.add(new Component[]{wac});
    }

    private void changeToSearchMode(AjaxRequestTarget target) {
        this.backupObjectId = this.selectedObjectId;
        this.backupText = (String)this.searchTextField.getModelObject();
        this.selectedObjectId = null;
        this.setModelObject(null);
        if (target != null) {
            target.add(new Component[]{this});
            String id = this.searchTextField.getMarkupId();
            target.appendJavaScript((CharSequence)("Wicket.DOM.get('" + id + "').focus();" + "Wicket.DOM.get('" + id + "').select();"));
        }
    }

    @Override
    public void searchCanceled(AjaxRequestTarget pTarget, boolean pForceRestore) {
        if (this.backupObjectId != null) {
            if (Strings.isEmpty((CharSequence)((CharSequence)this.searchTextField.getModelObject())) && !pForceRestore) {
                this.searchTextField.setModelObject(null);
                this.backupText = null;
                this.backupObjectId = null;
            } else if (this.backupText != null) {
                this.searchTextField.setModelObject((Object)this.backupText);
            }
            this.selectedObjectId = this.backupObjectId;
            pTarget.add(new Component[]{this});
        } else {
            this.clearSearchInput();
            pTarget.add(new Component[]{this.searchTextField});
        }
        this.notifyListeners(pTarget);
    }

    private void clearSearchInput() {
        this.searchTextField.setModelObject(null);
        this.selectedObjectId = null;
        this.searchTextField.clearInput();
        this.backupText = null;
    }

    private boolean isSearchMode() {
        return this.selectedObjectId == null;
    }

    protected void convertInput() {
        this.setConvertedInput(this.selectedObjectId);
    }

    protected void onComponentTag(ComponentTag pTag) {
        super.onComponentTag(pTag);
        pTag.setName("span");
        IValueMap attribMap = pTag.getAttributes();
        Iterator attrIterator = attribMap.entrySet().iterator();
        while (attrIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)attrIterator.next();
            String key = ((String)entry.getKey()).toLowerCase();
            if (ALLOWED_SPAN_ATTRIBUTES.contains(key)) continue;
            attrIterator.remove();
        }
    }

    private void notifyListeners(AjaxRequestTarget pTarget) {
        for (ObjectAutoCompleteSelectionChangeListener<I> listener : this.selectionChangeListeners) {
            listener.selectionChanged(pTarget, this.objectField.getModel());
        }
    }

    public TextField<String> getSearchTextField() {
        return this.searchTextField;
    }

    class ObjectUpdateBehavior
    extends AjaxEventBehavior {
        private static final long serialVersionUID = 1L;

        ObjectUpdateBehavior() {
            super("objectchange");
        }

        protected void onEvent(AjaxRequestTarget target) {
            ObjectAutoCompleteField.this.objectField.processInput();
            ObjectAutoCompleteField.this.searchTextField.processInput();
            target.add(new Component[]{ObjectAutoCompleteField.this});
            ObjectAutoCompleteField.this.notifyListeners(target);
            if (ObjectAutoCompleteField.this.clearInputOnSelection) {
                ObjectAutoCompleteField.this.clearSearchInput();
            }
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.setMethod(AjaxRequestAttributes.Method.POST);
            String searchTextFieldMarkupId = ObjectAutoCompleteField.this.searchTextField.getMarkupId();
            String objectFieldMarkupId = ObjectAutoCompleteField.this.objectField.getMarkupId();
            String deps = "return [].concat(Wicket.Form.serializeElement('" + searchTextFieldMarkupId + "')).concat(Wicket.Form.serializeElement('" + objectFieldMarkupId + "'))";
            attributes.getDynamicExtraParameters().add(deps);
        }
    }
}

