/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.objectautocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.objectautocomplete.AutoCompletionChoicesProvider;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteBehavior;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteCancelListener;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteField;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteRenderer;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteResponseRenderer;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteSelectionChangeListener;
import org.wicketstuff.objectautocomplete.ObjectReadOnlyRenderer;

public class ObjectAutoCompleteBuilder<O, I extends Serializable> {
    public static final String SEARCH_LINK_PANEL_ID = "searchLinkPanel";
    AutoCompletionChoicesProvider<O> choicesProvider;
    ObjectAutoCompleteCancelListener cancelListener;
    IAutoCompleteRenderer<O> autoCompleteRenderer;
    ObjectReadOnlyRenderer<I> readOnlyObjectRenderer;
    boolean preselect;
    long delay;
    int maxHeightInPx;
    boolean showListOnEmptyInput;
    List<ObjectAutoCompleteSelectionChangeListener<I>> selectionChangeListener;
    boolean searchOnClick;
    boolean searchOnPaste;
    Component searchLinkContent;
    String searchLinkText;
    IResource imageResource;
    ResourceReference imageResourceReference;
    boolean unchangeable;
    ObjectAutoCompleteResponseRenderer<O> autoCompleteResponseRenderer;
    String idProperty;
    Class<I> idType;
    boolean clearInputOnSelection;
    String choiceTagName;
    int width;
    Alignment alignement;

    public ObjectAutoCompleteBuilder(AutoCompletionChoicesProvider<O> pChoicesProvider) {
        this.choicesProvider = pChoicesProvider;
        this.cancelListener = null;
        this.autoCompleteRenderer = null;
        this.autoCompleteResponseRenderer = null;
        this.preselect = false;
        this.searchOnClick = false;
        this.searchOnPaste = false;
        this.showListOnEmptyInput = false;
        this.maxHeightInPx = -1;
        this.selectionChangeListener = new ArrayList<ObjectAutoCompleteSelectionChangeListener<I>>();
        this.searchLinkContent = null;
        this.searchLinkText = "[S]";
        this.readOnlyObjectRenderer = null;
        this.unchangeable = false;
        this.clearInputOnSelection = false;
        this.idProperty = "id";
        this.idType = null;
        this.choiceTagName = "LI";
        this.alignement = Alignment.LEFT;
        this.width = 0;
    }

    ObjectAutoCompleteBuilder<O, I> cancelListener(ObjectAutoCompleteCancelListener pCancelListener) {
        this.cancelListener = pCancelListener;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> autoCompleteRenderer(IAutoCompleteRenderer<O> renderer) {
        this.autoCompleteRenderer = renderer;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> autoCompleteResponseRenderer(ObjectAutoCompleteResponseRenderer<O> renderer) {
        this.autoCompleteResponseRenderer = renderer;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> idProperty(String pIdProperty) {
        this.idProperty = pIdProperty;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> idType(Class<I> type) {
        this.idType = type;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> readOnlyRenderer(ObjectReadOnlyRenderer<I> pReadOnlyObjectRenderer) {
        this.readOnlyObjectRenderer = pReadOnlyObjectRenderer;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> preselect() {
        this.preselect = true;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> delay(long pDelay) {
        this.delay = pDelay;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> searchOnClick() {
        this.searchOnClick = true;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> searchOnPaste() {
        this.searchOnPaste = true;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> searchLinkContent(Component pContent) {
        if (!pContent.getId().equals(SEARCH_LINK_PANEL_ID)) {
            throw new IllegalArgumentException("Panel used for the search link content must have id 'searchLinkPanel' (and not " + pContent.getId() + ")");
        }
        this.searchLinkContent = pContent;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> searchLinkImage(IResource pImageResource) {
        this.imageResource = pImageResource;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> searchLinkImage(ResourceReference pResourceReference) {
        this.imageResourceReference = pResourceReference;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> searchLinkText(String pText) {
        this.searchLinkText = pText;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> maxHeightInPx(int pMaxHeightInPx) {
        this.maxHeightInPx = pMaxHeightInPx;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> showListOnEmptyInput(boolean pShowListOnEmptyInput) {
        this.showListOnEmptyInput = pShowListOnEmptyInput;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> updateOnSelectionChange(ObjectAutoCompleteSelectionChangeListener<I> ... pListeners) {
        for (ObjectAutoCompleteSelectionChangeListener<I> listener : pListeners) {
            if (listener != null) continue;
            throw new IllegalArgumentException("A listener to be notified for an ajax update on selection change cannot be null");
        }
        this.selectionChangeListener.addAll(Arrays.asList(pListeners));
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> unchangeable() {
        this.unchangeable = true;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> clearInputOnSelection() {
        this.clearInputOnSelection = true;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> choiceTagName(String pTagName) {
        this.choiceTagName = pTagName;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> alignLeft() {
        this.alignement = Alignment.LEFT;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> alignRight() {
        this.alignement = Alignment.RIGHT;
        return this;
    }

    public ObjectAutoCompleteBuilder<O, I> width(int pWidth) {
        this.width = pWidth;
        return this;
    }

    public ObjectAutoCompleteBehavior<O> buildBehavior(Component objectIdHolder) {
        this.setupRenderer();
        return new ObjectAutoCompleteBehavior(objectIdHolder, this);
    }

    private void setupRenderer() {
        if (this.autoCompleteRenderer == null && this.autoCompleteResponseRenderer == null) {
            ObjectAutoCompleteRenderer r = new ObjectAutoCompleteRenderer();
            r.setIdProperty(this.idProperty);
            this.autoCompleteRenderer = r;
        } else {
            if (this.autoCompleteRenderer != null && this.autoCompleteResponseRenderer != null) {
                throw new IllegalStateException("Only one type of renderer can be set, either an IAutoCompleteRenderer() or an ObjectAutoCompleteResponseRenderer, but not both");
            }
            if (this.autoCompleteResponseRenderer != null) {
                this.autoCompleteResponseRenderer.setIdProperty(this.idProperty);
            } else {
                if (!(this.autoCompleteRenderer instanceof ObjectAutoCompleteRenderer)) {
                    throw new IllegalArgumentException("Can not set idProperty " + this.idProperty + " on a renderer of type " + this.autoCompleteRenderer.getClass() + ". Need to operate on a ObjectAutoCompleteRenderer");
                }
                ((ObjectAutoCompleteRenderer)this.autoCompleteRenderer).setIdProperty(this.idProperty);
            }
        }
    }

    public ObjectAutoCompleteField<O, I> build(String id) {
        this.setupRenderer();
        return this.build(id, (IModel<I>)new Model());
    }

    public ObjectAutoCompleteField<O, I> build(String id, IModel<I> model) {
        this.setupRenderer();
        return new ObjectAutoCompleteField(id, model, this);
    }

    static enum Alignment {
        LEFT,
        RIGHT;

    }
}

