/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.objectautocomplete;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AbstractAutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.wicketstuff.objectautocomplete.AutoCompletionChoicesProvider;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteBuilder;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteCancelListener;
import org.wicketstuff.objectautocomplete.ObjectAutoCompleteResponseRenderer;

public class ObjectAutoCompleteBehavior<O>
extends AbstractAutoCompleteBehavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference OBJECTAUTOCOMPLETE_JS = new JavaScriptResourceReference(ObjectAutoCompleteBehavior.class, "wicketstuff-objectautocomplete.js");
    private static final ResourceReference AUTOCOMPLETE_OBJECTIFIED_JS = new JavaScriptResourceReference(ObjectAutoCompleteBehavior.class, "wicketstuff-dropdown-list.js");
    private final Component objectElement;
    private final ObjectAutoCompleteCancelListener cancelListener;
    private final AutoCompletionChoicesProvider<O> choicesProvider;
    private final IAutoCompleteRenderer<O> renderer;
    private final ObjectAutoCompleteResponseRenderer<O> responseRenderer;
    private final String choiceTagName;
    private final ObjectAutoCompleteBuilder.Alignment alignment;
    private long width = 0L;
    private final long delay;
    private final boolean searchOnPaste;

    <I extends Serializable> ObjectAutoCompleteBehavior(Component pObjectElement, ObjectAutoCompleteBuilder<O, I> pBuilder) {
        this.renderer = pBuilder.autoCompleteRenderer;
        this.settings = new AutoCompleteSettings().setMaxHeightInPx(pBuilder.maxHeightInPx).setPreselect(pBuilder.preselect).setShowListOnEmptyInput(pBuilder.showListOnEmptyInput);
        this.choiceTagName = pBuilder.choiceTagName;
        this.width = pBuilder.width;
        this.alignment = pBuilder.alignement;
        this.objectElement = pObjectElement;
        this.responseRenderer = pBuilder.autoCompleteResponseRenderer;
        this.cancelListener = pBuilder.cancelListener;
        this.choicesProvider = pBuilder.choicesProvider;
        this.searchOnPaste = pBuilder.searchOnPaste;
        this.delay = pBuilder.delay;
    }

    public void renderHead(Component c, IHeaderResponse response) {
        this.abstractDefaultAjaxBehaviour_renderHead(c, response);
        this.initHead(response);
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setWicketAjaxResponse(false);
        attributes.setDataType("text");
    }

    protected void onRequest(final String input, RequestCycle requestCycle) {
        IRequestHandler target = new IRequestHandler(){

            public void respond(IRequestCycle requestCycle) {
                WebResponse response = (WebResponse)requestCycle.getResponse();
                String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
                response.setContentType("text/xml; charset=" + encoding);
                response.disableCaching();
                Iterator comps = ObjectAutoCompleteBehavior.this.getChoices(input);
                if (ObjectAutoCompleteBehavior.this.responseRenderer != null) {
                    ObjectAutoCompleteBehavior.this.responseRenderer.onRequest(comps, response, input);
                } else {
                    ObjectAutoCompleteBehavior.this.renderer.renderHeader((Response)response);
                    int renderedObjects = 0;
                    while (comps.hasNext()) {
                        Object comp = comps.next();
                        ObjectAutoCompleteBehavior.this.renderer.render(comp, (Response)response, input);
                        ++renderedObjects;
                    }
                    ObjectAutoCompleteBehavior.this.renderer.renderFooter((Response)response, renderedObjects);
                }
            }

            public void detach(IRequestCycle requestCycle) {
            }
        };
        requestCycle.scheduleRequestHandlerAfterCurrent(target);
    }

    private void abstractDefaultAjaxBehaviour_renderHead(Component component, IHeaderResponse response) {
        CoreLibrariesContributor.contributeAjax((Application)component.getApplication(), (IHeaderResponse)response);
    }

    protected void initHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)AUTOCOMPLETE_OBJECTIFIED_JS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)OBJECTAUTOCOMPLETE_JS));
        String id = this.getComponent().getMarkupId();
        String initJS = String.format("new Wicketstuff.ObjectAutoComplete('%s','%s','%s',%s);", id, this.objectElement.getMarkupId(), this.getCallbackUrl(), this.getSettings());
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)initJS));
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.cancelListener != null) {
            String keypress = "if (event) { var kc=Wicket.Event.keyCode(event); if (kc==27) {Wicket.Ajax.get({'u': '" + this.getCallbackUrl() + "&cancel=true&force=true'});" + "return false;" + "} else if (kc==13) " + "return false; " + "else return true;}";
            tag.put("onkeypress", (CharSequence)keypress);
        }
    }

    protected void respond(AjaxRequestTarget target) {
        RequestCycle requestCycle = RequestCycle.get();
        boolean cancel = requestCycle.getRequest().getRequestParameters().getParameterValue("cancel").toBoolean();
        boolean force = requestCycle.getRequest().getRequestParameters().getParameterValue("force").toBoolean();
        if (this.cancelListener != null && cancel) {
            this.cancelListener.searchCanceled(target, force);
        } else {
            super.respond(target);
        }
    }

    protected Iterator<O> getChoices(String input) {
        return this.choicesProvider.getChoices(input);
    }

    private CharSequence getSettings() {
        StringBuilder builder = new StringBuilder(this.constructSettingsJS());
        if (this.choiceTagName != null || this.alignment != null || this.width != 0L) {
            builder.setLength(builder.length() - 1);
            if (this.choiceTagName != null) {
                builder.append(",choiceTagName: '").append(this.choiceTagName.toUpperCase()).append("'");
            }
            if (this.alignment != null) {
                builder.append(",align: '").append(this.alignment == ObjectAutoCompleteBuilder.Alignment.LEFT ? "left" : "right").append("'");
            }
            if (this.width != 0L) {
                builder.append(",width: ").append(this.width);
            }
            if (this.delay != 0L) {
                builder.append(",delay: ").append(this.delay);
            }
            if (this.searchOnPaste) {
                builder.append(",searchOnPaste: true");
            }
            builder.append("}");
        }
        return builder;
    }
}

