/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.lazymodel.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Reflection {
    private static Logger log = LoggerFactory.getLogger(Reflection.class);

    private Reflection() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type resultType(Type declaringType, Type type) {
        if (type instanceof TypeVariable) {
            Class clazz;
            TypeVariable typeVariable = (TypeVariable)type;
            do {
                if (declaringType instanceof ParameterizedType) {
                    ParameterizedType parmeterizedType = (ParameterizedType)declaringType;
                    Type variableType = Reflection.variableType(parmeterizedType, typeVariable);
                    if (variableType != null) {
                        if (!(variableType instanceof TypeVariable)) return variableType;
                        if (declaringType instanceof BacktrackingParameterizedType) {
                            return Reflection.resultType(((BacktrackingParameterizedType)declaringType).declaringType, variableType);
                        }
                        log.debug("typeVariable {} resolves to typeVariable {}", (Object)typeVariable, (Object)variableType);
                        return null;
                    }
                    clazz = (Class)parmeterizedType.getRawType();
                    continue;
                }
                if (declaringType instanceof Class) {
                    clazz = (Class)declaringType;
                    continue;
                }
                log.debug("unsupported ownerType {}", (Object)declaringType);
                return null;
            } while ((declaringType = clazz.getGenericSuperclass()) != Object.class);
            log.debug("typeVariable {} cannot be resolved", (Object)typeVariable);
            return null;
        }
        if (!(type instanceof ParameterizedType)) return type;
        return new BacktrackingParameterizedType(declaringType, (ParameterizedType)type);
    }

    public static Type variableType(ParameterizedType type, TypeVariable<?> variable) {
        Class clazz = (Class)type.getRawType();
        TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
        String name = variable.getName();
        int index = 0;
        for (TypeVariable candidate : typeParameters) {
            if (candidate.getName().equals(name)) {
                return type.getActualTypeArguments()[index];
            }
            ++index;
        }
        return null;
    }

    public static Class<?> getClass(Type type) {
        Class clazz;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        } else {
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            throw new IllegalArgumentException(String.format("%s is not a class or parameterizedType", type));
        }
        return clazz;
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        if (method.getParameterTypes().length == 0) {
            Class<?> returnType = method.getReturnType();
            if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) && returnType != Void.TYPE) {
                return true;
            }
            if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2)) && (returnType == Boolean.TYPE || returnType == Boolean.class)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isListIndex(Method method) {
        Class<?>[] parameters;
        return "get".equals(method.getName()) && (parameters = method.getParameterTypes()).length == 1 && parameters[0] == Integer.TYPE;
    }

    private static class BacktrackingParameterizedType
    implements ParameterizedType {
        private Type declaringType;
        private ParameterizedType type;

        public BacktrackingParameterizedType(Type declaringType, ParameterizedType type) {
            this.declaringType = declaringType;
            this.type = type;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.type.getActualTypeArguments();
        }

        @Override
        public Type getRawType() {
            return this.type.getRawType();
        }

        @Override
        public Type getOwnerType() {
            return this.type.getOwnerType();
        }
    }
}

