/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.lazymodel.reflect;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.wicket.WicketRuntimeException;
import org.wicketstuff.lazymodel.reflect.IMethodResolver;
import org.wicketstuff.lazymodel.reflect.Reflection;

public class DefaultMethodResolver
implements IMethodResolver {
    @Override
    public Method getMethod(Class<?> owner, Serializable id) {
        for (Class<?> candidate = owner; candidate != null; candidate = candidate.getSuperclass()) {
            for (Method method : candidate.getDeclaredMethods()) {
                if (!id.equals(this.getId(method))) continue;
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return method;
            }
        }
        throw new IllegalArgumentException(String.format("unknown method %s#%s", owner.getName(), id));
    }

    @Override
    public Serializable getId(Method method) {
        String name = method.getName();
        StringBuilder id = new StringBuilder();
        if (Reflection.isGetter(method)) {
            if (name.startsWith("get")) {
                id.append(Character.toLowerCase(name.charAt(3)));
                id.append(name.substring(4));
                return id.toString();
            }
            if (name.startsWith("is")) {
                id.append(Character.toLowerCase(name.charAt(2)));
                id.append(name.substring(3));
                return id.toString();
            }
        }
        Class<?>[] parameters = method.getParameterTypes();
        id.append(method.getName());
        id.append("(");
        for (int p = 0; p < parameters.length; ++p) {
            String simpleName;
            if (p > 0) {
                id.append(",");
            }
            if (parameters[p].isArray()) {
                id.append("[");
            }
            if ((simpleName = parameters[p].getSimpleName()).isEmpty()) continue;
            id.append(simpleName.charAt(0));
        }
        id.append(")");
        return id.toString();
    }

    @Override
    public Method getSetter(Method getter) {
        Method setter;
        String name = getter.getName();
        Class<?>[] getterParameters = getter.getParameterTypes();
        if (name.equals("get") && Map.class.isAssignableFrom(getter.getDeclaringClass())) {
            name = "put";
        } else if (name.startsWith("get")) {
            name = "set" + name.substring(3);
        } else if (name.startsWith("is")) {
            name = "set" + name.substring(2);
        } else {
            throw new WicketRuntimeException(String.format("no setter for %s#%s", getter.getClass(), name));
        }
        Class[] setterParameters = new Class[getterParameters.length + 1];
        System.arraycopy(getterParameters, 0, setterParameters, 0, getterParameters.length);
        setterParameters[getterParameters.length] = getter.getReturnType();
        Class<?> owner = getter.getDeclaringClass();
        while (true) {
            try {
                setter = owner.getDeclaredMethod(name, setterParameters);
            }
            catch (Exception e) {
                if (owner == Object.class) {
                    throw new WicketRuntimeException(String.format("no setter for %s#%s", getter.getDeclaringClass(), name));
                }
                owner = owner.getSuperclass();
                continue;
            }
            break;
        }
        try {
            setter.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return setter;
    }
}

