/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.lazymodel.reflect;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.lazymodel.reflect.IProxyFactory;

public class CachingProxyFactory
implements IProxyFactory {
    private final ConcurrentHashMap<Object, IProxyFactory> scopes = Generics.newConcurrentHashMap((int)2);
    private final IProxyFactory factory;

    public CachingProxyFactory(IProxyFactory factory) {
        this.factory = factory;
    }

    @Override
    public Class<?> createClass(Class<?> clazz) {
        return this.getFactory().createClass(clazz);
    }

    @Override
    public Object createInstance(Class<?> proxyClass, IProxyFactory.Callback callback) {
        return this.getFactory().createInstance(proxyClass, callback);
    }

    @Override
    public IProxyFactory.Callback getCallback(Object proxy) {
        return this.getFactory().getCallback(proxy);
    }

    private IProxyFactory getFactory() {
        IProxyFactory tmpResult;
        Object key = Application.exists() ? Application.get() : CachingProxyFactory.class;
        IProxyFactory result = this.scopes.get(key);
        if (result == null && (tmpResult = this.scopes.putIfAbsent(key, result = new ApplicationScope())) != null) {
            result = tmpResult;
        }
        return result;
    }

    public void destroy(Application application) {
        this.scopes.remove(application);
    }

    private class NOT_PROXYABLE {
        private NOT_PROXYABLE() {
        }
    }

    private class ApplicationScope
    implements IProxyFactory {
        private final Map<Class<?>, Class<?>> proxyClasses = new ConcurrentHashMap();

        private ApplicationScope() {
        }

        @Override
        public Class<?> createClass(Class<?> clazz) {
            Class<Object> proxyClazz = this.proxyClasses.get(clazz);
            if (proxyClazz == null) {
                proxyClazz = CachingProxyFactory.this.factory.createClass(clazz);
                if (proxyClazz == null) {
                    proxyClazz = NOT_PROXYABLE.class;
                }
                this.proxyClasses.put(clazz, proxyClazz);
            }
            if (proxyClazz == NOT_PROXYABLE.class) {
                proxyClazz = null;
            }
            return proxyClazz;
        }

        @Override
        public Object createInstance(Class<?> proxyClass, IProxyFactory.Callback callback) {
            return CachingProxyFactory.this.factory.createInstance(proxyClass, callback);
        }

        @Override
        public IProxyFactory.Callback getCallback(Object proxy) {
            return CachingProxyFactory.this.factory.getCallback(proxy);
        }
    }
}

