/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.lazymodel.reflect;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.lazymodel.reflect.IMethodResolver;

public class CachingMethodResolver
implements IMethodResolver {
    private final ConcurrentHashMap<Object, IMethodResolver> scopes = Generics.newConcurrentHashMap((int)2);
    private final IMethodResolver resolver;

    public CachingMethodResolver(IMethodResolver resolver) {
        this.resolver = resolver;
    }

    private IMethodResolver getResolver() {
        IMethodResolver tmpResult;
        Object key = Application.exists() ? Application.get() : CachingMethodResolver.class;
        IMethodResolver result = this.scopes.get(key);
        if (result == null && (tmpResult = this.scopes.putIfAbsent(key, result = new ApplicationScope())) != null) {
            result = tmpResult;
        }
        return result;
    }

    @Override
    public Method getMethod(Class<?> owner, Serializable id) {
        return this.getResolver().getMethod(owner, id);
    }

    @Override
    public Serializable getId(Method method) {
        return this.getResolver().getId(method);
    }

    @Override
    public Method getSetter(Method getter) {
        return this.getResolver().getSetter(getter);
    }

    public void destroy(Application application) {
        this.scopes.remove(application);
    }

    private class ApplicationScope
    implements IMethodResolver {
        private final Map<String, Method> methods = new ConcurrentHashMap<String, Method>();
        private final Map<Method, Serializable> ids = new ConcurrentHashMap<Method, Serializable>();
        private final Map<Method, Method> setters = new ConcurrentHashMap<Method, Method>();

        private ApplicationScope() {
        }

        @Override
        public Method getMethod(Class<?> owner, Serializable id) {
            String key = owner.getName() + ":" + id;
            Method method = this.methods.get(key);
            if (method == null) {
                method = CachingMethodResolver.this.resolver.getMethod(owner, id);
                this.methods.put(key, method);
            }
            return method;
        }

        @Override
        public Serializable getId(Method method) {
            Serializable id = this.ids.get(method);
            if (id == null) {
                id = CachingMethodResolver.this.resolver.getId(method);
                this.ids.put(method, id);
            }
            return id;
        }

        @Override
        public Method getSetter(Method getter) {
            Method setter = this.setters.get(getter);
            if (setter == null) {
                setter = CachingMethodResolver.this.resolver.getSetter(getter);
                this.setters.put(getter, setter);
            }
            return setter;
        }
    }
}

