/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.lazymodel;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IChainingModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.model.IPropertyReflectionAwareModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.wicketstuff.lazymodel.IObjectTypeAwareModel;
import org.wicketstuff.lazymodel.reflect.CachingMethodResolver;
import org.wicketstuff.lazymodel.reflect.DefaultMethodResolver;
import org.wicketstuff.lazymodel.reflect.Evaluation;
import org.wicketstuff.lazymodel.reflect.IMethodResolver;
import org.wicketstuff.lazymodel.reflect.Reflection;

public class LazyModel<T>
implements IModel<T>,
IObjectClassAwareModel<T>,
IObjectTypeAwareModel<T>,
IPropertyReflectionAwareModel<T> {
    private static final long serialVersionUID = 1L;
    public static IMethodResolver methodResolver = new CachingMethodResolver(new DefaultMethodResolver());
    private static final Object[] EMPTY_ARGS = new Object[0];
    protected final Object target;
    protected final Object stack;

    LazyModel(Object target, Object stack) {
        this.target = target;
        this.stack = stack;
    }

    public IModel<T> loadableDetachable() {
        return new LoadableDetachableWrapper();
    }

    public Class<T> getObjectClass() {
        Type type = this.getObjectType();
        if (type == null) {
            return null;
        }
        return Reflection.getClass(type);
    }

    @Override
    public Type getObjectType() {
        if (this.target == null) {
            return null;
        }
        Type type = this.getTargetType();
        if (type != null) {
            MethodIterator methodIterator = new MethodIterator();
            while (methodIterator.hasNext()) {
                methodIterator.next(Reflection.getClass(type));
                if ((type = Reflection.resultType(type, methodIterator.method.getGenericReturnType())) != null) continue;
                break;
            }
        }
        return type;
    }

    public Field getPropertyField() {
        return null;
    }

    public Method getPropertyGetter() {
        this.checkBound();
        Type type = this.getTargetType();
        if (type != null) {
            MethodIterator methodIterator = new MethodIterator();
            while (methodIterator.hasNext()) {
                methodIterator.next(Reflection.getClass(type));
                if ((type = Reflection.resultType(type, methodIterator.method.getGenericReturnType())) != null) continue;
                return null;
            }
            if (Reflection.isGetter(methodIterator.method)) {
                return methodIterator.method;
            }
        }
        return null;
    }

    public Method getPropertySetter() {
        this.checkBound();
        Method getter = this.getPropertyGetter();
        if (getter == null) {
            return null;
        }
        return methodResolver.getSetter(getter);
    }

    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
        if (this.stack instanceof IDetachable) {
            ((IDetachable)this.stack).detach();
        }
        if (this.stack instanceof Object[]) {
            for (Object object : (Object[])this.stack) {
                if (!(object instanceof IDetachable)) continue;
                ((IDetachable)object).detach();
            }
        }
    }

    public T getObject() {
        this.checkBound();
        Object result = this.target;
        if (result instanceof IModel) {
            result = ((IModel)result).getObject();
        }
        MethodIterator methodIterator = new MethodIterator();
        while (result != null && methodIterator.hasNext()) {
            methodIterator.next(result.getClass());
            result = methodIterator.get(result);
        }
        return (T)result;
    }

    public void setObject(T result) {
        this.checkBound();
        Object target = this.target;
        MethodIterator methodIterator = new MethodIterator();
        if (!methodIterator.hasNext()) {
            if (target instanceof IModel) {
                ((IModel)target).setObject(result);
                return;
            }
            throw new UnsupportedOperationException();
        }
        if (target instanceof IModel) {
            target = ((IModel)target).getObject();
        }
        if (target == null) {
            throw new WicketRuntimeException("no target");
        }
        methodIterator.next(target.getClass());
        while (target != null && methodIterator.hasNext()) {
            target = methodIterator.get(target);
            methodIterator.next(target.getClass());
        }
        methodIterator.set(target, result);
    }

    public Object getTarget() {
        return this.target;
    }

    public LazyModel<T> bind(Object target) {
        return new LazyModel<T>(target, this.stack);
    }

    public String toString() {
        if (this.target != null) {
            try {
                return this.getPath();
            }
            catch (WicketRuntimeException wicketRuntimeException) {
                // empty catch block
            }
        }
        return "";
    }

    public String getPath() {
        this.checkBound();
        StringBuilder string = new StringBuilder();
        Type type = this.getTargetType();
        if (type == null) {
            throw new WicketRuntimeException("cannot detect target type");
        }
        MethodIterator methodIterator = new MethodIterator();
        while (methodIterator.hasNext()) {
            methodIterator.next(Reflection.getClass(type));
            if (string.length() > 0) {
                string.append(".");
            }
            string.append(methodIterator.id.toString());
            type = Reflection.resultType(type, methodIterator.method.getGenericReturnType());
        }
        return string.toString();
    }

    private Type getTargetType() {
        Type type = null;
        if (this.target instanceof IModel) {
            Object object;
            type = LazyModel.getType((IModel)this.target);
            if (type instanceof TypeVariable) {
                type = null;
            }
            if ((type == null || type instanceof Class) && (object = ((IModel)this.target).getObject()) != null) {
                type = object.getClass();
            }
        } else {
            type = this.target.getClass();
        }
        return type;
    }

    private void checkBound() {
        if (this.target == null) {
            throw new WicketRuntimeException("not bound to a target");
        }
    }

    public static <T> T from(T target) {
        if (target == null) {
            throw new WicketRuntimeException("target must not be null");
        }
        BoundEvaluation evaluation = new BoundEvaluation(target.getClass(), target);
        return (T)evaluation.proxy();
    }

    public static <T> T from(Class<T> targetType) {
        if (targetType == null) {
            throw new WicketRuntimeException("target type must not be null");
        }
        Evaluation evaluation = new Evaluation(targetType);
        return (T)evaluation.proxy();
    }

    public static <T> T from(IModel<T> target, Class<T> type) {
        return (T)new BoundEvaluation(type, target).proxy();
    }

    public static <T> T from(IModel<T> target) {
        if (target == null) {
            throw new WicketRuntimeException("target must not be null");
        }
        Type type = LazyModel.getType(target);
        if (type == null) {
            throw new WicketRuntimeException("cannot detect target type");
        }
        BoundEvaluation evaluation = new BoundEvaluation(type, target);
        return (T)evaluation.proxy();
    }

    private static Type getType(IModel<?> model) {
        Type type = null;
        if (model instanceof IObjectTypeAwareModel) {
            type = ((IObjectTypeAwareModel)model).getObjectType();
        } else if (model instanceof IObjectClassAwareModel) {
            type = ((IObjectClassAwareModel)model).getObjectClass();
        }
        if (type == null) {
            try {
                type = model.getClass().getMethod("getObject", new Class[0]).getGenericReturnType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type instanceof TypeVariable) {
                type = Reflection.resultType(model.getClass(), type);
            }
        }
        return type;
    }

    public static <R> LazyModel<R> model(R result) {
        return LazyModel.model(Evaluation.eval(result));
    }

    private static <R> LazyModel<R> model(Evaluation<R> evaluation) {
        Object[] stack;
        Object target = null;
        if (evaluation instanceof BoundEvaluation) {
            target = ((BoundEvaluation)evaluation).target;
        }
        if (evaluation.stack.size() == 0) {
            stack = null;
        } else if (evaluation.stack.size() == 1) {
            stack = methodResolver.getId((Method)evaluation.stack.get(0));
        } else {
            Object[] array = new Object[evaluation.stack.size()];
            int index = 0;
            while (index < array.length) {
                Method method = (Method)evaluation.stack.get(index);
                array[index] = methodResolver.getId(method);
                ++index;
                for (int p = 0; p < method.getParameterTypes().length; ++p) {
                    LazyModel<Object> param = evaluation.stack.get(index);
                    if (param instanceof Evaluation) {
                        param = LazyModel.model(param);
                    }
                    array[index] = param;
                    ++index;
                }
            }
            stack = array;
        }
        return new LazyModel(target, stack);
    }

    public static <R> String path(R result) {
        Method method;
        Evaluation<R> evaluation = Evaluation.eval(result);
        StringBuilder path = new StringBuilder();
        for (int index = 0; index < evaluation.stack.size(); index += 1 + method.getParameterTypes().length) {
            if (path.length() > 0) {
                path.append(".");
            }
            method = (Method)evaluation.stack.get(index);
            path.append(methodResolver.getId(method));
        }
        return path.toString();
    }

    private static class BoundEvaluation<R>
    extends Evaluation<R> {
        public final Object target;

        public BoundEvaluation(Type type, Object target) {
            super(type);
            this.target = target;
        }
    }

    private class LoadableDetachableWrapper
    extends LoadableDetachableModel<T>
    implements IObjectClassAwareModel<T>,
    IObjectTypeAwareModel<T>,
    IChainingModel<T> {
        private static final long serialVersionUID = 1L;
        private transient Type type;

        private LoadableDetachableWrapper() {
        }

        protected T load() {
            return LazyModel.this.getObject();
        }

        public void setObject(T object) {
            super.setObject(object);
            LazyModel.this.setObject(object);
        }

        public Class<T> getObjectClass() {
            Type type = this.getObjectType();
            if (type == null) {
                return null;
            }
            return Reflection.getClass(type);
        }

        @Override
        public Type getObjectType() {
            if (this.type == null) {
                this.type = LazyModel.this.getObjectType();
            }
            return this.type;
        }

        public IModel<?> getChainedModel() {
            return LazyModel.this;
        }

        public void setChainedModel(IModel<?> model) {
            throw new UnsupportedOperationException();
        }

        public void detach() {
            super.detach();
            this.type = null;
            LazyModel.this.detach();
        }
    }

    private class MethodIterator {
        private int index = 0;
        private Serializable id;
        private Method method;
        private int count = 0;

        private MethodIterator() {
        }

        public boolean hasNext() {
            if (LazyModel.this.stack instanceof Object[]) {
                return this.index < ((Object[])LazyModel.this.stack).length;
            }
            return LazyModel.this.stack != null && this.index == 0;
        }

        public void next(Class<?> clazz) {
            this.id = LazyModel.this.stack instanceof Object[] ? (Serializable)((Object[])LazyModel.this.stack)[this.index] : (Serializable)LazyModel.this.stack;
            ++this.index;
            this.method = methodResolver.getMethod(clazz, this.id);
            this.count = this.method.getParameterTypes().length;
            this.index += this.count;
        }

        public Object get(Object target) {
            Object[] args;
            if (this.count == 0) {
                args = EMPTY_ARGS;
            } else {
                args = new Object[this.count];
                this.fillArguments(args);
            }
            try {
                if (target instanceof List && Reflection.isListIndex(this.method) && ((List)target).size() <= (Integer)args[0]) {
                    return null;
                }
                return this.method.invoke(target, args);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException((Throwable)ex);
            }
        }

        public void set(Object target, Object result) {
            Method setter = methodResolver.getSetter(this.method);
            Object[] args = new Object[this.count + 1];
            this.fillArguments(args);
            args[this.count] = result;
            try {
                setter.invoke(target, args);
            }
            catch (Exception ex) {
                throw new WicketRuntimeException((Throwable)ex);
            }
        }

        private void fillArguments(Object[] args) {
            for (int a = 0; a < this.count; ++a) {
                Object arg = ((Object[])LazyModel.this.stack)[this.index - this.count + a];
                if (arg instanceof LazyModel) {
                    arg = ((LazyModel)arg).getObject();
                }
                args[a] = arg;
            }
        }
    }
}

