/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.lazymodel;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.wicketstuff.lazymodel.LazyModel;

public class LazyColumn<T, S, R>
extends AbstractColumn<T, S>
implements IExportableColumn<T, S> {
    private static final long serialVersionUID = 1L;
    private final LazyModel<R> cellModel;

    public LazyColumn(IModel<String> displayModel, R evaluationResult) {
        this(displayModel, evaluationResult, null);
    }

    public LazyColumn(IModel<String> displayModel, LazyModel<R> cellModel) {
        this(displayModel, cellModel, null);
    }

    public LazyColumn(IModel<String> displayModel, R evaluationResult, S sortProperty) {
        this(displayModel, LazyModel.model(evaluationResult), sortProperty);
    }

    public LazyColumn(IModel<String> displayModel, LazyModel<R> cellModel, S sortProperty) {
        super(displayModel, sortProperty);
        this.cellModel = cellModel;
    }

    public void detach() {
        super.detach();
        this.cellModel.detach();
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        item.add(new Component[]{new Label(componentId, this.getDataModel(rowModel))});
    }

    public IModel<R> getDataModel(IModel<T> rowModel) {
        return this.cellModel.bind(rowModel);
    }
}

