/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.renderer;

import com.github.openjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.wicketstuff.jquery.core.renderer.IChoiceRenderer;
import org.wicketstuff.jquery.core.renderer.TextRenderer;

public class ChoiceRenderer<T>
extends TextRenderer<T>
implements IChoiceRenderer<T> {
    private static final long serialVersionUID = 1L;
    private static final String VALUE_FIELD = "value";
    private String valueExpression;

    public ChoiceRenderer() {
        this.valueExpression = null;
    }

    public ChoiceRenderer(String textExpression) {
        super(textExpression);
        this.valueExpression = null;
    }

    public ChoiceRenderer(String textExpression, String valueExpression) {
        super(textExpression);
        this.valueExpression = valueExpression;
    }

    public String getValueField() {
        if (this.valueExpression != null) {
            return this.valueExpression;
        }
        return VALUE_FIELD;
    }

    public String getValue(T object) {
        Object value;
        if (this.valueExpression != null && (value = PropertyResolver.getValue((String)this.valueExpression, object)) != null) {
            return value.toString();
        }
        return this.getText(object);
    }

    public List<String> getFields() {
        return Arrays.asList(this.getTextField(), this.getValueField());
    }

    public JSONObject render(T object) {
        JSONObject o = new JSONObject();
        o.put(this.getTextField(), (Object)this.getText(object));
        o.put(this.getValueField(), (Object)this.getValue(object));
        return o;
    }
}

