/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.icon;

import com.inmethod.icon.Icon;
import java.io.Serializable;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class IconImage
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;

    public IconImage(String id) {
        super(id);
    }

    public IconImage(String id, Icon icon) {
        this(id, (IModel<Icon>)new Model((Serializable)icon));
    }

    public IconImage(String id, IModel<Icon> model) {
        super(id, model);
    }

    public Icon getIcon() {
        return (Icon)this.getDefaultModelObject();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Icon icon = this.getIcon();
        if (tag.getName().toLowerCase().equals("img")) {
            int width = icon.getWidth();
            int height = icon.getHeight();
            tag.put("src", icon.getUrl());
            if (width != -1 && height != -1) {
                tag.put("width", width);
                tag.put("height", height);
            }
        } else {
            String style = tag.getAttribute("style");
            if (style == null) {
                style = "";
            } else if (style.length() > 0) {
                style = style + ";";
            }
            style = style + "background-image: url('" + icon.getUrl() + "'); background-repeat: no-repeat;";
            tag.put("style", (CharSequence)style);
        }
    }
}

