/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.toolbar.paging;

import com.inmethod.grid.IDataSource;
import com.inmethod.grid.datagrid.DataGrid;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.io.IClusterable;

public class NavigatorLabel
extends Label {
    private static final long serialVersionUID = 1L;

    public <D extends IDataSource<T>, T> NavigatorLabel(String id, DataGrid<D, T, ?> table) {
        super(id);
        this.setDefaultModel((IModel)new StringResourceModel("NavigatorLabel", (Component)this, (IModel)new Model(new LabelModelObject<D, T>(table)), "Showing ${from} to ${to} of ${of}", new Object[0]));
    }

    private class LabelModelObject<D extends IDataSource<T>, T>
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final DataGrid<D, T, ?> table;

        public LabelModelObject(DataGrid<D, T, ?> table) {
            this.table = table;
        }

        public String getOf() {
            long total = this.table.getTotalRowCount();
            return total != -1L ? "" + total : NavigatorLabel.this.getString("unknown", null, "unknown");
        }

        public long getFrom() {
            if (this.table.getTotalRowCount() == 0L) {
                return 0L;
            }
            return this.table.getCurrentPage() * this.table.getRowsPerPage() + 1L;
        }

        public long getTo() {
            if (this.table.getTotalRowCount() == 0L) {
                return 0L;
            }
            long count = this.getFrom() + this.table.getCurrentPageItemCount() - 1L;
            return count;
        }
    }
}

