/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.datagrid;

import com.inmethod.grid.IDataSource;
import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.IGridSortState;
import com.inmethod.grid.common.AbstractGridRow;
import com.inmethod.grid.common.AbstractPageableView;
import com.inmethod.grid.common.AttachPrelightBehavior;
import com.inmethod.grid.datagrid.DataGrid;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.model.IModel;

public abstract class DataGridBody<D extends IDataSource<T>, T, S>
extends Panel
implements IPageable {
    private static final long serialVersionUID = 1L;

    public DataGridBody(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        this.add(new Component[]{new Data("row")});
    }

    protected abstract D getDataSource();

    protected abstract long getRowsPerPage();

    protected abstract IGridSortState<S> getSortState();

    protected abstract Collection<IGridColumn<D, T, S>> getActiveColumns();

    protected abstract boolean isItemSelected(IModel<T> var1);

    protected abstract void rowPopulated(WebMarkupContainer var1);

    private Data getData() {
        return (Data)this.get("row");
    }

    protected Item<T> insertRow(IModel<T> rowModel) {
        Item item = this.getData().createItem(this.getCurrentPageItemCount() + 1L, rowModel);
        this.getData().add(new Component[]{item});
        return item;
    }

    protected Item<T> createItem(long index, IModel<T> rowModel) {
        return this.getData().createItem(index, rowModel);
    }

    long getTotalRowCount() {
        return this.getData().getTotalRowCount();
    }

    void clearCache() {
        this.getData().clearCache();
    }

    long getCurrentPageItemCount() {
        return this.getData().getCurrentPageItemCount();
    }

    public long getCurrentPage() {
        return this.getData().getCurrentPage();
    }

    public long getPageCount() {
        return this.getData().getPageCount();
    }

    public void setCurrentPage(long page) {
        this.getData().setCurrentPage(page);
    }

    class Data
    extends AbstractPageableView<T> {
        private static final long serialVersionUID = 1L;

        private Data(String id) {
            super(id);
            this.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        }

        protected D getDataSource() {
            return DataGridBody.this.getDataSource();
        }

        @Override
        protected long getRowsPerPage() {
            return DataGridBody.this.getRowsPerPage();
        }

        @Override
        protected IGridSortState<S> getSortState() {
            return DataGridBody.this.getSortState();
        }

        @Override
        protected IDataSource.IQuery wrapQuery(final IDataSource.IQuery original) {
            return new DataGrid.IGridQuery(){

                @Override
                public long getCount() {
                    return original.getCount();
                }

                @Override
                public long getFrom() {
                    return original.getFrom();
                }

                @Override
                public IGridSortState<S> getSortState() {
                    return original.getSortState();
                }

                @Override
                public long getTotalCount() {
                    return original.getTotalCount();
                }

                public DataGrid<D, T, S> getDataGrid() {
                    return (DataGrid)((Object)DataGridBody.this.findParent(DataGrid.class));
                }
            };
        }

        protected void populateItem(final Item<T> item) {
            item.add(new Component[]{new AbstractGridRow<D, T, S>("item", item.getDefaultModel()){
                private static final long serialVersionUID = 1L;

                @Override
                protected Collection<IGridColumn<D, T, S>> getActiveColumns() {
                    return DataGridBody.this.getActiveColumns();
                }

                @Override
                protected int getRowNumber() {
                    return item.getIndex();
                }
            }});
            item.add(new Behavior[]{new AttachPrelightBehavior()});
            DataGridBody.this.rowPopulated((WebMarkupContainer)item);
        }

        protected Item<T> newItem(String id, int index, IModel<T> model) {
            RowItem item = new RowItem(id, index, model);
            item.setOutputMarkupId(true);
            return item;
        }

        protected Item<T> createItem(long index, IModel<T> itemModel) {
            int i = index > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)index;
            return this.newItemFactory().newItem(i, itemModel);
        }

        protected class RowItem
        extends Item<T> {
            private static final long serialVersionUID = 1L;

            protected RowItem(String id, int index, IModel<T> model) {
                super(id, index, model);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String klass = tag.getAttribute("class");
                if (klass == null) {
                    klass = "";
                } else if (klass.length() > 0) {
                    klass = klass + " ";
                }
                klass = this.getIndex() % 2 == 0 ? klass + "imxt-even" : klass + "imxt-odd";
                klass = klass + " imxt-want-prelight imxt-grid-row";
                if (DataGridBody.this.isItemSelected(this.getDefaultModel())) {
                    klass = klass + " imxt-selected";
                }
                tag.put("class", (CharSequence)klass);
            }
        }
    }
}

