/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.common;

import com.inmethod.grid.IGridSortState;
import com.inmethod.grid.common.AbstractGrid;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class GridSortState<S>
implements IGridSortState<S>,
IClusterable {
    private static final long serialVersionUID = 1L;
    private final List<IGridSortState.ISortStateColumn<S>> columns = new ArrayList<IGridSortState.ISortStateColumn<S>>();
    private final AbstractGrid<?, ?, S> grid;

    public GridSortState(AbstractGrid<?, ?, S> grid) {
        this.grid = grid;
    }

    private int getSortStateColumnIndex(S propertyName) {
        int i = 0;
        for (IGridSortState.ISortStateColumn<S> column : this.columns) {
            if (column.getPropertyName().equals(propertyName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clearSortState() {
        this.columns.clear();
    }

    public void clearSortState(S propertyName) {
        this.setSortState(propertyName, null);
    }

    public IGridSortState.ISortStateColumn<S> getSortStateForProperty(S propertyName) {
        int i = this.getSortStateColumnIndex(propertyName);
        if (i != -1) {
            return this.columns.get(i);
        }
        return null;
    }

    public void setSortState(S propertyName, IGridSortState.Direction direction) {
        Args.notNull(propertyName, (String)"propertyName");
        if (propertyName instanceof String && Strings.isEmpty((CharSequence)((String)propertyName))) {
            throw new IllegalArgumentException("'propertyName' must be a non-empty string.");
        }
        int index = this.getSortStateColumnIndex(propertyName);
        if (index != -1) {
            this.columns.remove(index);
        }
        if (direction != null) {
            SortStateColumn column = new SortStateColumn(propertyName, direction);
            this.columns.add(0, column);
        }
    }

    @Override
    public List<IGridSortState.ISortStateColumn<S>> getColumns() {
        return this.columns;
    }

    @Override
    public AbstractGrid<?, ?, S> getGrid() {
        return this.grid;
    }

    private static class SortStateColumn<S>
    implements IGridSortState.ISortStateColumn<S>,
    IClusterable {
        private static final long serialVersionUID = 1L;
        private final S propertyName;
        private final IGridSortState.Direction direction;

        private SortStateColumn(S propertyName, IGridSortState.Direction direction) {
            this.propertyName = propertyName;
            this.direction = direction;
        }

        @Override
        public S getPropertyName() {
            return this.propertyName;
        }

        @Override
        public IGridSortState.Direction getDirection() {
            return this.direction;
        }
    }
}

