/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.common;

import com.inmethod.grid.IGridColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.util.io.IClusterable;

public class ColumnsState
implements IClusterable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final Entry[] stateArray;

    public <M, I, S> ColumnsState(Collection<IGridColumn<M, I, S>> columns) {
        this.stateArray = new Entry[columns.size()];
        int i = 0;
        for (IGridColumn<M, I, S> column : columns) {
            this.stateArray[i] = new Entry(column.getId());
            ++i;
        }
    }

    public ColumnsState(Entry[] columnStates) {
        this.stateArray = columnStates;
    }

    private int getEntryIndex(String id) {
        for (int i = 0; i < this.stateArray.length; ++i) {
            if (!this.stateArray[i].getColumnId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public Entry getEntry(String id) {
        int i = this.getEntryIndex(id);
        return i != -1 ? this.stateArray[i] : null;
    }

    private Entry getColumnStateChecked(String id) {
        Entry state = this.getEntry(id);
        if (state == null) {
            throw new IllegalArgumentException("Column state for column with id '" + id + "' not found.");
        }
        return state;
    }

    public void setColumnWidth(String id, int newWidth) {
        Entry state = this.getColumnStateChecked(id);
        state.setCurrentWidth(newWidth);
    }

    public int getColumnWidth(String id) {
        Entry state = this.getColumnStateChecked(id);
        return state.getCurrentWidth();
    }

    public void setColumnVisibility(String id, boolean newValue) {
        Entry state = this.getColumnStateChecked(id);
        state.setVisible(newValue);
    }

    public boolean getColumnVisibility(String id) {
        Entry state = this.getColumnStateChecked(id);
        return state.isVisible();
    }

    public Collection<Entry> getColumnStates() {
        return Arrays.asList(this.stateArray);
    }

    public void setColumnIndex(String id, int newIndex) {
        int index = this.getEntryIndex(id);
        if (index == -1) {
            throw new IllegalArgumentException("Column state for column with id '" + id + "' not found.");
        }
        if (newIndex < 0 || newIndex > this.stateArray.length - 1) {
            throw new IndexOutOfBoundsException("'newIndex' parameter is out of range.");
        }
        if (newIndex > index) {
            Entry source = this.stateArray[index];
            for (int i = index; i < newIndex; ++i) {
                this.stateArray[i] = this.stateArray[i + 1];
            }
            this.stateArray[newIndex] = source;
        } else if (newIndex < index) {
            Entry source = this.stateArray[index];
            for (int i = index; i > newIndex; --i) {
                this.stateArray[i] = this.stateArray[i - 1];
            }
            this.stateArray[newIndex] = source;
        }
    }

    public ColumnsState clone() {
        return (ColumnsState)WicketObjects.cloneObject((Object)this);
    }

    <M, I, S> boolean matches(Collection<IGridColumn<M, I, S>> columns) {
        if (this.stateArray.length != columns.size()) {
            return false;
        }
        for (IGridColumn<M, I, S> column : columns) {
            if (this.getEntryIndex(column.getId()) != -1) continue;
            return false;
        }
        return true;
    }

    void updateColumnsState(String state) {
        String[] segments;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        TreeSet<Integer> indices = new TreeSet<Integer>();
        for (String segment : segments = state.split(";")) {
            int index;
            String[] parts = segment.split(",");
            if (parts.length != 2 || (index = this.getEntryIndex(parts[0])) == -1) continue;
            Entry entry = this.stateArray[index];
            entry.setCurrentWidth(Integer.parseInt(parts[1]));
            entries.add(entry);
            indices.add(index);
        }
        int i = 0;
        for (Integer index : indices) {
            this.stateArray[index.intValue()] = (Entry)entries.get(i);
            ++i;
        }
    }

    private <M, I, S> IGridColumn<M, I, S> getColumn(String id, Collection<IGridColumn<M, I, S>> columns) {
        for (IGridColumn<M, I, S> column : columns) {
            if (!column.getId().equals(id)) continue;
            return column;
        }
        return null;
    }

    public <M, I, S> Collection<IGridColumn<M, I, S>> getVisibleColumns(Collection<IGridColumn<M, I, S>> allColumns) {
        ArrayList<IGridColumn<M, I, S>> result = new ArrayList<IGridColumn<M, I, S>>();
        for (Entry state : this.stateArray) {
            IGridColumn<M, I, S> column;
            if (!state.isVisible() || (column = this.getColumn(state.getColumnId(), allColumns)) == null) continue;
            result.add(column);
        }
        return result;
    }

    public static class Entry
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final String columnId;
        private int currentWidth = -1;
        private boolean visible = true;

        public Entry(String columnId) {
            this.columnId = columnId;
        }

        public int getCurrentWidth() {
            return this.currentWidth;
        }

        public void setCurrentWidth(int currentWidth) {
            this.currentWidth = currentWidth;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public String getColumnId() {
            return this.columnId;
        }
    }
}

