/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.common;

import com.inmethod.grid.IGridColumn;
import com.inmethod.grid.SizeUnit;
import com.inmethod.grid.common.ColumnsHeader;
import com.inmethod.grid.common.ColumnsState;
import com.inmethod.grid.common.GridSortState;
import com.inmethod.grid.toolbar.AbstractHeaderToolbar;
import com.inmethod.grid.toolbar.AbstractToolbar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class AbstractGrid<M, I, S>
extends Panel {
    private static final long serialVersionUID = 1L;
    SubmitColumnStateBehavior submitColumnStateBehavior = new SubmitColumnStateBehavior();
    private ColumnsState columnState;
    private RepeatingView topToolbarContainer;
    private RepeatingView bottomToolbarContainer;
    private RepeatingView headerToolbarContainer;
    public static final String INTERNAL_TOOLBAR_ITEM_ID = "item";
    private final List<IGridColumn<M, I, S>> columns;
    private GridSortState<S> sortState = null;
    public static final String THEME_VISTA = "imxt-vista";
    private String theme = "imxt-vista";
    private static int FLAG_RENDERING = 524288;
    public static final JavaScriptResourceReference JS_YAHOO = new JavaScriptResourceReference(AbstractGrid.class, "res/yahoo.js");
    public static final JavaScriptResourceReference JS_EVENT = new JavaScriptResourceReference(AbstractGrid.class, "res/event.js");
    public static final JavaScriptResourceReference JS_DOM = new JavaScriptResourceReference(AbstractGrid.class, "res/dom.js");
    public static final JavaScriptResourceReference JS_SCRIPT = new JavaScriptResourceReference(AbstractGrid.class, "res/script.js");
    public static final JavaScriptResourceReference JS_SCRIPT_JQ = new JavaScriptResourceReference(AbstractGrid.class, "res/script-jq.js");
    public static final PackageResourceReference CSS = new PackageResourceReference(AbstractGrid.class, "res/style.css");
    private boolean useYui = false;
    private String lastClickedColumn = null;
    private boolean clickRowToSelect = false;
    private boolean clickRowToDeselect = true;
    private int contentHeight = 0;
    private SizeUnit contentHeightSizeUnit;
    private boolean selectToEdit = false;
    private static final MetaDataKey<Boolean> EDITING = new MetaDataKey<Boolean>(){
        private static final long serialVersionUID = 1L;
    };

    public AbstractGrid(String id, IModel<M> model, List<IGridColumn<M, I, S>> columns) {
        super(id, model);
        this.setVersioned(false);
        this.columnsSanityCheck(columns);
        this.setOutputMarkupId(true);
        this.columns = columns;
        this.add(new Component[]{new Header("header")});
        Form form = new Form("form");
        this.add(new Component[]{form});
        WebMarkupContainer bodyContainer = new WebMarkupContainer("bodyContainer"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (AbstractGrid.this.getContentHeight() > 0 && AbstractGrid.this.getContentHeightSizeUnit() != null) {
                    tag.put("style", (CharSequence)("height:" + AbstractGrid.this.getContentHeight() + AbstractGrid.this.getContentHeightSizeUnit().getValue()));
                }
            }
        };
        form.add(new Component[]{bodyContainer});
        bodyContainer.setOutputMarkupId(true);
        bodyContainer.add(new Component[]{new Label("firstRow", (IModel)new EmptyRowModel()).setEscapeModelStrings(false)});
        Component[] componentArray = new Component[1];
        this.topToolbarContainer = new RepeatingView("topToolbarContainer");
        componentArray[0] = this.topToolbarContainer;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.bottomToolbarContainer = new RepeatingView("bottomToolbarContainer");
        componentArray2[0] = this.bottomToolbarContainer;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.headerToolbarContainer = new RepeatingView("headerToolbarContainer");
        componentArray3[0] = this.headerToolbarContainer;
        this.add(componentArray3);
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)AbstractGrid.this.getInitializationJavascript()));
            }
        }});
        this.columnState = new ColumnsState(columns);
        this.add(new Behavior[]{this.submitColumnStateBehavior});
    }

    public Form<Void> getForm() {
        return (Form)this.get("form");
    }

    protected void columnSanityCheck(IGridColumn<M, I, S> column) {
        String id = column.getId();
        if (Strings.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("Column id must be a non-empty string.");
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_') continue;
            throw new IllegalStateException("Column id contains invalid character(s).");
        }
        if (column.isResizable() && column.getSizeUnit() != SizeUnit.PX) {
            throw new IllegalStateException("Resizable columns size must be in the PX unit.");
        }
    }

    private void columnsSanityCheck(List<IGridColumn<M, I, S>> columns) {
        IGridColumn<M, I, S> column;
        int i;
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            this.columnSanityCheck(column);
        }
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            for (int j = 0; j < columns.size(); ++j) {
                if (i == j) continue;
                IGridColumn<M, I, S> otherColumn = columns.get(j);
                if (!column.getId().equals(otherColumn.getId())) continue;
                throw new IllegalStateException("Each column must have unique id");
            }
        }
    }

    public void onColumnStateChanged() {
    }

    public ColumnsState getColumnState() {
        return this.columnState;
    }

    public void setColumnState(ColumnsState columnState) {
        if (columnState == null) {
            throw new IllegalArgumentException("ColumnStateManager may not be null.");
        }
        if (!columnState.matches(this.columns)) {
            throw new IllegalArgumentException("ColumnStateManager doesn't match current columns.");
        }
        this.columnState = columnState;
    }

    protected void onInitialize() {
        super.onInitialize();
        for (IGridColumn<M, I, S> column : this.columns) {
            column.setGrid(this);
        }
    }

    protected void onBeforeRender() {
        this.setFlag(FLAG_RENDERING, true);
        super.onBeforeRender();
    }

    protected void onAfterRender() {
        super.onAfterRender();
        this.setFlag(FLAG_RENDERING, false);
    }

    public boolean isRendering() {
        return this.getFlag(FLAG_RENDERING);
    }

    private void addToolbar(AbstractToolbar<M, I, S> toolbar, RepeatingView container) {
        Args.notNull(toolbar, (String)"toolbar");
        WebMarkupContainer item = new WebMarkupContainer(container.newChildId());
        item.setRenderBodyOnly(true);
        item.add(new Component[]{toolbar});
        container.add(new Component[]{item});
    }

    public void addTopToolbar(AbstractToolbar<M, I, S> toolbar) {
        this.addToolbar(toolbar, this.topToolbarContainer);
    }

    public void addBottomToolbar(AbstractToolbar<M, I, S> toolbar) {
        this.addToolbar(toolbar, this.bottomToolbarContainer);
    }

    public void addHeaderToolbar(AbstractHeaderToolbar<M, I, S> toolbar) {
        this.addToolbar(toolbar, this.headerToolbarContainer);
    }

    protected void onSortStateChanged(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    private String getInitializationJavascript() {
        AppendingStringBuffer sb = new AppendingStringBuffer(128);
        sb.append("(function() {\n");
        sb.append("var columns = [\n");
        Collection<IGridColumn<M, I, S>> columns = this.getActiveColumns();
        int i = 0;
        for (IGridColumn<M, I, S> column : columns) {
            ++i;
            sb.append("  {");
            sb.append(" minSize: " + column.getMinSize());
            sb.append(", maxSize: " + column.getMaxSize());
            sb.append(", id: \"" + column.getId() + "\"");
            sb.append(", resizable: " + column.isResizable());
            sb.append(", reorderable: " + column.isReorderable());
            sb.append("  }");
            if (i != columns.size()) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append("];\n");
        sb.append("var submitStateCallback = ");
        sb.append((Object)this.submitColumnStateBehavior.getCallbackScript());
        sb.append("\n");
        sb.append("InMethod.XTableManager.instance.register(\"" + this.getMarkupId() + "\", columns, submitStateCallback);\n");
        sb.append("})();\n");
        return sb.toString();
    }

    public Collection<IGridColumn<M, I, S>> getActiveColumns() {
        return this.getColumnState().getVisibleColumns(this.columns);
    }

    public List<IGridColumn<M, I, S>> getAllColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public GridSortState<S> getSortState() {
        if (this.sortState == null) {
            this.sortState = new GridSortState(this);
        }
        return this.sortState;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getTheme() {
        return this.theme;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        String klass = tag.getAttribute("class");
        if (klass == null) {
            klass = "";
        }
        if (klass.length() > 0) {
            klass = klass + " ";
        }
        klass = klass + "imxt-grid " + this.getTheme();
        klass = klass + " imxt-selectable";
        tag.put("class", (CharSequence)klass);
        if (tag.getName().equals("table")) {
            tag.setName("div");
        }
    }

    public void renderHead(IHeaderResponse response) {
        CoreLibrariesContributor.contributeAjax((Application)this.getApplication(), (IHeaderResponse)response);
        if (this.isUseYui()) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS_YAHOO));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS_EVENT));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS_DOM));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS_SCRIPT));
        } else {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS_SCRIPT_JQ));
        }
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)CSS));
    }

    public abstract void selectItem(IModel<I> var1, boolean var2);

    public abstract void selectAllVisibleItems();

    public abstract void resetSelectedItems();

    public abstract boolean isItemSelected(IModel<I> var1);

    public abstract Collection<IModel<I>> getSelectedItems();

    public abstract void setAllowSelectMultiple(boolean var1);

    public abstract boolean isAllowSelectMultiple();

    public abstract void update();

    protected void onItemSelectionChanged(IModel<I> item, boolean newValue) {
    }

    public IGridColumn<M, I, S> getLastClickedColumn() {
        for (IGridColumn<M, I, S> column : this.columns) {
            if (!column.getId().equals(this.lastClickedColumn)) continue;
            return column;
        }
        return null;
    }

    public void cleanLastClickedColumn() {
        this.lastClickedColumn = null;
    }

    protected boolean disableRowClickNotifications() {
        return false;
    }

    protected void onRowPopulated(final WebMarkupContainer rowComponent) {
        if (this.disableRowClickNotifications()) {
            return;
        }
        rowComponent.add(new Behavior[]{new AjaxFormSubmitBehavior(this.getForm(), "click"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
            }

            protected void onError(AjaxRequestTarget target) {
            }

            protected void onEvent(AjaxRequestTarget target) {
                Form form = super.getForm();
                form.visitFormComponentsPostOrder(new IVisitor<FormComponent<?>, Void>(){

                    public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                        if (formComponent.isVisibleInHierarchy()) {
                            formComponent.inputChanged();
                        }
                    }
                });
                String column = AbstractGrid.this.getRequest().getRequestParameters().getParameterValue("column").toString();
                AbstractGrid.this.lastClickedColumn = column;
                IModel model = rowComponent.getDefaultModel();
                IGridColumn lastClickedColumn = AbstractGrid.this.getLastClickedColumn();
                if (lastClickedColumn != null) {
                    if (AbstractGrid.this.onCellClicked(target, model, lastClickedColumn)) {
                        return;
                    }
                    if (lastClickedColumn.cellClicked(model)) {
                        return;
                    }
                }
                AbstractGrid.this.onRowClicked(target, model);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                String columnParameter = "return {'column': Wicket.$(attrs.c).imxtClickedColumn}";
                attributes.getDynamicExtraParameters().add(columnParameter);
                String precondition = "return InMethod.XTable.canSelectRow(attrs.event);";
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition((CharSequence)precondition);
                attributes.setAllowDefault(true);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }

            public CharSequence getCallbackScript() {
                return this.getCallbackFunction(new CallbackParameter[]{CallbackParameter.context((String)"col")});
            }
        }});
    }

    protected boolean onCellClicked(AjaxRequestTarget target, IModel<I> rowModel, IGridColumn<M, I, S> column) {
        return false;
    }

    protected void onRowClicked(AjaxRequestTarget target, IModel<I> rowModel) {
        boolean selected;
        if (this.isClickRowToSelect() && (!(selected = this.isItemSelected(rowModel)) || this.isClickRowToDeselect())) {
            this.selectItem(rowModel, !selected);
            this.update();
        }
    }

    public AbstractGrid<M, I, S> setClickRowToSelect(boolean clickRowToSelect) {
        this.clickRowToSelect = clickRowToSelect;
        return this;
    }

    public boolean isClickRowToSelect() {
        return this.clickRowToSelect;
    }

    public void setClickRowToDeselect(boolean clickRowToDeselect) {
        this.clickRowToDeselect = clickRowToDeselect;
    }

    public boolean isClickRowToDeselect() {
        return this.clickRowToDeselect;
    }

    public void setContentHeight(Integer contentHeight, SizeUnit contentSizeUnit) {
        this.contentHeight = contentHeight != null ? contentHeight : 0;
        this.contentHeightSizeUnit = contentSizeUnit;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public SizeUnit getContentHeightSizeUnit() {
        return this.contentHeightSizeUnit;
    }

    public abstract WebMarkupContainer findParentRow(Component var1);

    protected abstract WebMarkupContainer findRowComponent(IModel<I> var1);

    public abstract void markItemDirty(IModel<I> var1);

    public void setSelectToEdit(boolean selectToEdit) {
        this.selectToEdit = selectToEdit;
    }

    public boolean isSelectToEdit() {
        return this.selectToEdit;
    }

    public void setItemEdit(IModel<I> rowModel, boolean edit) {
        if (this.isSelectToEdit()) {
            this.selectItem(rowModel, edit);
        } else {
            boolean editing;
            WebMarkupContainer rowComponent = this.findRowComponent(rowModel);
            if (rowComponent != null && (editing = Boolean.TRUE.equals(rowComponent.getMetaData(EDITING))) != edit) {
                rowComponent.setMetaData(EDITING, (Object)edit);
                this.markItemDirty(rowModel);
            }
        }
    }

    public boolean isItemEdited(IModel<I> rowModel) {
        if (this.isSelectToEdit()) {
            return this.isItemSelected(rowModel);
        }
        WebMarkupContainer rowComponent = this.findRowComponent(rowModel);
        if (rowComponent != null) {
            return Boolean.TRUE.equals(rowComponent.getMetaData(EDITING));
        }
        return false;
    }

    public boolean isUseYui() {
        return this.useYui;
    }

    public void setUseYui(boolean useYui) {
        this.useYui = useYui;
    }

    private class Header
    extends ColumnsHeader<M, I, S> {
        private static final long serialVersionUID = 1L;

        private Header(String id) {
            super(id);
        }

        @Override
        Collection<IGridColumn<M, I, S>> getActiveColumns() {
            return AbstractGrid.this.getActiveColumns();
        }

        @Override
        int getColumnWidth(IGridColumn<M, I, S> column) {
            int width = AbstractGrid.this.getColumnState().getColumnWidth(column.getId());
            if (width != -1 && column.getSizeUnit() == SizeUnit.PX) {
                return width;
            }
            return column.getInitialSize();
        }

        @Override
        protected void sortStateChanged(AjaxRequestTarget target) {
            AbstractGrid.this.onSortStateChanged(target);
        }
    }

    private class EmptyRowModel
    extends Model<String> {
        private static final long serialVersionUID = 1L;

        private EmptyRowModel() {
        }

        public String getObject() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < AbstractGrid.this.getActiveColumns().size(); ++i) {
                result.append("<td></td>");
            }
            return result.toString();
        }
    }

    private class SubmitColumnStateBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private SubmitColumnStateBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            String state = AbstractGrid.this.getRequest().getRequestParameters().getParameterValue("columnState").toString(null);
            if (!Strings.isEmpty((CharSequence)state)) {
                AbstractGrid.this.columnState.updateColumnsState(state);
                AbstractGrid.this.onColumnStateChanged();
            }
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            String columnStateParameter = "return {'columnState': columnState}";
            attributes.getDynamicExtraParameters().add(columnStateParameter);
        }

        public CharSequence getCallbackScript() {
            return this.getCallbackFunction(new CallbackParameter[]{CallbackParameter.context((String)"columnState")});
        }
    }
}

