/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.common.AbstractGrid;
import com.inmethod.icon.Icon;
import com.inmethod.icon.IconImage;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

abstract class SubmitCancelPanel<M, I>
extends Panel {
    private static final long serialVersionUID = 1L;
    private final AbstractGrid<M, I, ?> grid;

    protected AbstractGrid<M, I, ?> getGrid() {
        return this.grid;
    }

    SubmitCancelPanel(String id, final IModel<I> model, AbstractGrid<M, I, ?> grid) {
        super(id);
        this.grid = grid;
        SubmitLink submit = new SubmitLink("submit"){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return SubmitCancelPanel.this.getGrid().isItemEdited(model);
            }
        };
        submit.setDefaultFormProcessing(false);
        this.add(new Component[]{submit});
        submit.add(new Component[]{new IconImage("icon", this.getSubmitIcon())});
        AjaxLink<Void> cancel = new AjaxLink<Void>("cancel"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                SubmitCancelPanel.this.onCancel(target);
            }

            public boolean isVisible() {
                return SubmitCancelPanel.this.getGrid().isItemEdited(model);
            }
        };
        this.add(new Component[]{cancel});
        cancel.add(new Component[]{new IconImage("icon", this.getCancelIcon())});
    }

    protected abstract void onSubmitted(AjaxRequestTarget var1);

    protected abstract void onError(AjaxRequestTarget var1);

    protected abstract void onCancel(AjaxRequestTarget var1);

    protected abstract Icon getSubmitIcon();

    protected abstract Icon getCancelIcon();

    private class SubmitLink
    extends AjaxSubmitLink {
        private static final long serialVersionUID = 1L;

        public SubmitLink(String id) {
            super(id, SubmitCancelPanel.this.getGrid().getForm());
        }

        private boolean formComponentActive(FormComponent<?> formComponent) {
            return formComponent.isVisibleInHierarchy() && formComponent.isValid() && formComponent.isEnabled() && formComponent.isEnableAllowed();
        }

        protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
            WebMarkupContainer gridRow = SubmitCancelPanel.this.getGrid().findParentRow((Component)SubmitCancelPanel.this);
            final Boolean[] error = new Boolean[]{false};
            gridRow.visitChildren(FormComponent.class, new IVisitor<FormComponent<?>, Void>(){

                public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                    if (SubmitLink.this.formComponentActive(formComponent)) {
                        formComponent.validate();
                        if (formComponent.isValid()) {
                            if (formComponent.processChildren()) {
                                return;
                            }
                            visit.dontGoDeeper();
                            return;
                        }
                        error[0] = true;
                        visit.dontGoDeeper();
                    }
                }
            });
            if (!error[0].booleanValue()) {
                gridRow.visitChildren(FormComponent.class, new IVisitor<FormComponent<?>, Void>(){

                    public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                        if (SubmitLink.this.formComponentActive(formComponent)) {
                            formComponent.updateModel();
                            if (formComponent.processChildren()) {
                                return;
                            }
                            visit.dontGoDeeper();
                            return;
                        }
                    }
                });
                SubmitCancelPanel.this.onSubmitted(target);
            } else {
                SubmitCancelPanel.this.onError(target);
            }
        }

        protected void onError(AjaxRequestTarget target, Form<?> form) {
        }
    }
}

