/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.SizeUnit;
import com.inmethod.grid.column.AbstractColumn;
import com.inmethod.grid.column.editable.SubmitCancelPanel;
import com.inmethod.grid.common.Icons;
import com.inmethod.icon.Icon;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class SubmitCancelColumn<M, I, S>
extends AbstractColumn<M, I, S> {
    private static final long serialVersionUID = 1L;

    public SubmitCancelColumn(String columnId, IModel<String> headerModel) {
        super(columnId, headerModel);
        this.setResizable(false);
        this.setSizeUnit(SizeUnit.PX);
        this.setInitialSize(44);
    }

    @Override
    public Component newCell(WebMarkupContainer parent, String componentId, final IModel<I> rowModel) {
        return new SubmitCancelPanel<M, I>(componentId, rowModel, this.getGrid()){
            private static final long serialVersionUID = 1L;

            private WebMarkupContainer getRowComponent() {
                return this.getGrid().findParentRow((Component)this);
            }

            @Override
            protected void onCancel(AjaxRequestTarget target) {
                SubmitCancelColumn.this.onCancel(target, rowModel, this.getRowComponent());
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                SubmitCancelColumn.this.onError(target, rowModel, this.getRowComponent());
            }

            @Override
            protected void onSubmitted(AjaxRequestTarget target) {
                SubmitCancelColumn.this.onSubmitted(target, rowModel, this.getRowComponent());
            }

            @Override
            protected Icon getSubmitIcon() {
                return SubmitCancelColumn.this.getSubmitIcon();
            }

            @Override
            protected Icon getCancelIcon() {
                return SubmitCancelColumn.this.getCancelIcon();
            }
        };
    }

    protected Icon getSubmitIcon() {
        return Icons.OK;
    }

    protected Icon getCancelIcon() {
        return Icons.CANCEL;
    }

    protected void onCancel(AjaxRequestTarget target, IModel<I> rowModel, WebMarkupContainer rowComponent) {
        this.getGrid().setItemEdit(rowModel, false);
        this.getGrid().update();
    }

    protected void onError(AjaxRequestTarget target, IModel<I> rowModel, WebMarkupContainer rowComponent) {
        target.add(new Component[]{rowComponent});
    }

    protected void onSubmitted(AjaxRequestTarget target, IModel<I> rowModel, WebMarkupContainer rowComponent) {
        this.getGrid().setItemEdit(rowModel, false);
        this.getGrid().update();
    }

    @Override
    public boolean cellClicked(IModel<I> rowModel) {
        if (this.getGrid().isClickRowToSelect() && this.getGrid().isSelectToEdit()) {
            return false;
        }
        this.getGrid().setItemEdit(rowModel, true);
        this.getGrid().update();
        return true;
    }

    @Override
    public String getCellCssClass(IModel<I> rowModel, int rowNum) {
        return this.getGrid().isItemEdited(rowModel) ? "imxt-edit" : "imxt-want-prelight imxt-edit";
    }
}

