/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.column.editable.EditableCellPanel;
import com.inmethod.grid.column.editable.TextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class EditablePropertyColumn<M, I, P, S>
extends PropertyColumn<M, I, P, S> {
    private static final long serialVersionUID = 1L;

    public EditablePropertyColumn(String columnId, IModel<String> headerModel, String propertyExpression, S sortProperty) {
        super(columnId, headerModel, propertyExpression, sortProperty);
    }

    public EditablePropertyColumn(String columnId, IModel<String> headerModel, String propertyExpression) {
        super(columnId, headerModel, propertyExpression);
    }

    public EditablePropertyColumn(IModel<String> headerModel, String propertyExpression, S sortProperty) {
        super(headerModel, propertyExpression, sortProperty);
    }

    public EditablePropertyColumn(IModel<String> headerModel, String propertyExpression) {
        super(headerModel, propertyExpression);
    }

    @Override
    public boolean isLightWeight(IModel<I> rowModel) {
        return !this.getGrid().isItemEdited(rowModel);
    }

    protected IModel<P> getFieldModel(IModel<I> rowModel) {
        return new PropertyModel(rowModel, this.getPropertyExpression());
    }

    protected EditableCellPanel<M, I, P, S> newCellPanel(String componentId, IModel<I> rowModel, IModel<P> cellModel) {
        return new TextFieldPanel(componentId, cellModel, rowModel, this);
    }

    @Override
    public Component newCell(WebMarkupContainer parent, String componentId, IModel<I> rowModel) {
        EditableCellPanel<M, I, P, S> panel = this.newCellPanel(componentId, rowModel, this.getFieldModel(rowModel));
        this.addValidators(panel.getEditComponent());
        return panel;
    }

    protected void addValidators(FormComponent<P> component) {
    }

    @Override
    public String getCellCssClass(IModel<I> rowModel, int rowNum) {
        String prelight;
        String string = prelight = this.isClickToEdit() ? "imxt-want-prelight" : "";
        if (this.getGrid().isItemEdited(rowModel)) {
            return "imxt-no-padding-cell " + prelight + " imxt-edited-cell";
        }
        return prelight;
    }

    @Override
    public boolean cellClicked(IModel<I> rowModel) {
        if (!this.isClickToEdit() || this.getGrid().isClickRowToSelect() && this.getGrid().isSelectToEdit()) {
            return false;
        }
        this.getGrid().setItemEdit(rowModel, true);
        this.getGrid().update();
        return true;
    }

    protected boolean isClickToEdit() {
        return true;
    }
}

