/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.column.editable;

import com.inmethod.grid.column.AbstractColumn;
import com.inmethod.grid.column.editable.EditableCellPanel;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.datetime.DateConverter;
import org.apache.wicket.datetime.StyleDateConverter;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

public class DateTextFieldPanel<M, I, S>
extends EditableCellPanel<M, I, Date, S> {
    private static final long serialVersionUID = 1L;
    private static final String DateTextField_ID = "dateTextField";

    public DateTextFieldPanel(String id, IModel<Date> date, IModel<I> rowModel, AbstractColumn<M, I, S> column, DateConverter dc) {
        super(id, column, rowModel);
        DateTextField tf = this.newDateTextField(DateTextField_ID, date, dc);
        tf.setOutputMarkupId(true);
        tf.setLabel(column.getHeaderModel());
        this.add(new Component[]{tf});
    }

    protected DateTextField newDateTextField(String id, IModel<Date> date, DateConverter dc) {
        return new DefaultDateTextField(id, date, dc);
    }

    @Override
    public FormComponent<Date> getEditComponent() {
        return (FormComponent)this.get(DateTextField_ID);
    }

    protected static class DefaultDateTextField
    extends DateTextField {
        private static final long serialVersionUID = 1L;

        protected DefaultDateTextField(String id, IModel<Date> object) {
            super(id, object, (DateConverter)new StyleDateConverter(false));
        }

        protected DefaultDateTextField(String id, IModel<Date> object, DateConverter dc) {
            super(id, object, dc);
        }

        protected DefaultDateTextField(String id, IModel<Date> date, boolean applyTimeZoneDifference, String dateStyle) {
            super(id, date, (DateConverter)new StyleDateConverter(dateStyle, applyTimeZoneDifference));
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            if (!this.isValid()) {
                tag.put("class", (CharSequence)"imxt-invalid");
                FeedbackMessage message = this.getFeedbackMessages().first();
                if (message != null) {
                    tag.put("title", (CharSequence)message.getMessage().toString());
                }
            }
        }
    }
}

